% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targets.R
\name{add_targets}
\alias{add_targets}
\title{Add targets to WORCS Project}
\usage{
add_targets(worcs_directory = ".", verbose = TRUE, ...)
}
\arguments{
\item{worcs_directory}{Character, indicating the WORCS project directory
to which to save data. The default value "." points to the current directory.
Default: '.'}

\item{verbose}{Logical. Whether or not to print status messages to the
console. Default: \code{TRUE}}

\item{...}{Arguments passed to \code{targets::use_targets()}.}
}
\value{
No return value. This function is called for its side effects.
}
\description{
Add a computational pipeline to a \code{worcs} project using the
\code{targets} and \code{tarchetypes} packages (which must be installed). See those
packages for extensive documentation.
}
\examples{
# Create directory to run the example
old_wd <- getwd()
test_dir <- file.path(tempdir(), "targets")
dir.create(test_dir)
setwd(test_dir)
file.create(".worcs")
add_targets()
# Cleaning example directory
setwd(old_wd)
unlink(test_dir, recursive = TRUE)
}
