% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_energy.R
\name{calculate_energy}
\alias{calculate_energy}
\title{Calculate Energy Outputs of Individuals}
\usage{
calculate_energy(
  sel,
  referenceHeight,
  RotorHeight,
  SurfaceRoughness,
  wnkl,
  distanz,
  polygon1,
  resol,
  RotorR,
  dirSpeed,
  srtm_crop,
  topograp,
  cclRaster,
  weibull,
  plotit = FALSE
)
}
\arguments{
\item{sel}{A data.frame of an individual of the current population
(data.frame)}

\item{referenceHeight}{The height at which the incoming wind speeds were
measured (numeric)}

\item{RotorHeight}{The desired height of the turbines}

\item{SurfaceRoughness}{A surface roughness length of the considered area in
m. If the terrain effect model is activated, a surface roughness will be
calculated for every grid cell with the elevation and land cover
information}

\item{wnkl}{Indicates the angle at which no wake influences are considered
(numeric)}

\item{distanz}{Indicates the distance after which the wake effects are
considered to be eliminated}

\item{polygon1}{The considered area as shapefile}

\item{resol}{The resolution of the grid in meter}

\item{RotorR}{The desired rotor radius in meter}

\item{dirSpeed}{The wind speed and direction data.frame}

\item{srtm_crop}{A list of 3 raster, with 1) the elevation, 2) an orographic
and 3) a terrain raster. Calculated in \code{\link{genetic_algorithm}}}

\item{topograp}{Logical value that indicates whether the terrain effect model
is activated (TRUE) or deactivated (FALSE)}

\item{cclRaster}{A Corine Land Cover raster that has to be downloaded
previously. See also the details at \code{\link{windfarmGA}} The raster
will only be used when the terrain effect model is activated. (raster)}

\item{weibull}{A raster representing the estimated wind speeds}

\item{plotit}{Logical value. If TRUE, the process will be plotted. 
Default is FALSE.}
}
\value{
Returns a list of an individual of the current generation with
  resulting wake effects, energy outputs, efficiency rates for every wind
  direction. The length of the list will be the amount of incoming wind
  directions.
}
\description{
Calculate the energy output and efficiency rates of an
  individual in the current population under all given wind directions and
  speeds. If the terrain effect model is activated, the main calculations to
  model those effects will be done in this function.
}
\examples{
\dontrun{
## Create a random shapefile
library(sp)
Polygon1 <- Polygon(rbind(c(4498482, 2668272), c(4498482, 2669343),
                    c(4499991, 2669343), c(4499991, 2668272)))
Polygon1 <- Polygons(list(Polygon1),1);
Polygon1 <- SpatialPolygons(list(Polygon1))
Projection <- "+init=epsg:3035"
proj4string(Polygon1) <- CRS(Projection)

## Create a uniform and unidirectional wind data.frame and plot the
## resulting wind rose
data.in <- data.frame(ws = 12, wd = 0)
windrosePlot <- plot_windrose(data = data.in, spd = data.in$ws,
                dir = data.in$wd, dirres=10, spdmax=20)

## Assign the rotor radius and a factor of the radius for grid spacing.
Rotor= 50; fcrR= 3
resGrid <- grid_area(shape = Polygon1, resol = Rotor*fcrR, prop=1,
                      plotGrid = TRUE)
## Assign the indexed data frame to new variable. Element 2 of the list
## is the grid, saved as SpatialPolygon.
resGrid1 <- resGrid[[1]]

## Create an initial population with the indexed Grid, 15 turbines and
## 100 individuals.
initpop <- init_population(Grid = resGrid1, n = 15, nStart = 100)

## Calculate the expected energy output of the first individual of the
## population.
par(mfrow = c(1,2))
plot(Polygon1); points(initpop[[1]][,'X'],initpop[[1]][,'Y'], pch=20,cex=2)
plot(resGrid[[2]], add = TRUE)
resCalcEn <- calculate_energy(sel=initpop[[1]],referenceHeight= 50,
                   RotorHeight= 50, SurfaceRoughness = 0.14,wnkl = 20,
                   distanz = 100000, resol = 200,dirSpeed = data.in,
                   RotorR = 50, polygon1 = Polygon1, topograp = FALSE,
                   weibull = FALSE)
resCalcEn <- as.data.frame(resCalcEn)
plot(Polygon1, main = resCalcEn[,'Energy_Output_Red'][[1]])
points(x = resCalcEn[,'Bx'], y = resCalcEn[,'By'], pch = 20)


## Create a variable and multidirectional wind data.frame and plot the
## resulting wind rose
data.in10 <- data.frame(ws = runif(10,1,25), wd = runif(10,0,360))
windrosePlot <- plot_windrose(data = data.in10, spd = data.in10$ws,
                dir = data.in10$wd, dirres=10, spdmax=20)

## Calculate the energy outputs for the first individual with more than one
## wind direction.
resCalcEn <- calculate_energy(sel=initpop[[1]],referenceHeight= 50,
                   RotorHeight= 50, SurfaceRoughness = 0.14,wnkl = 20,
                   distanz = 100000, resol = 200,dirSpeed = data.in10,
                   RotorR = 50, polygon1 = Polygon1, topograp = FALSE,
                   weibull = FALSE)
}

}
\seealso{
Other Wind Energy Calculation Functions: 
\code{\link{barometric_height}()},
\code{\link{get_dist_angles}()},
\code{\link{turbine_influences}()}
}
\concept{Wind Energy Calculation Functions}
