% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_climate.R
\name{daily_climate_counties}
\alias{daily_climate_counties}
\title{Retrieve average daily weather data for a list of US counties.}
\usage{
daily_climate_counties(
  fips_list,
  var = c("prcp", "snow", "snwd", "tmax", "tmin"),
  date_min = "2015-01-01",
  date_max = "2015-12-31",
  coverage = 0.9
)
}
\arguments{
\item{fips_list}{A vector of FIPS codes of the counties to pull the daily weather data for.
One can use the output from the \code{get_counties} function as follows:
\code{fips_list=pull(counties, 'fips')}}

\item{var}{A character vector specifying desired weather variables. For
example, \code{var = c("tmin", "tmax", "prcp")} for maximum temperature,
minimum temperature, and precipitation. The default is \code{"all"},
which includes all available weather variables at any weather station in
the county. For a full list of all
possible variable names, see NOAA's README file for the Daily Global
Historical Climatology Network (GHCN-Daily) at
\url{https://www1.ncdc.noaa.gov/pub/data/ghcn/daily/readme.txt}. Many of
the weather variables are available for some, but not all, monitors, so
your output from this function may not include all the variables
specified using this argument. If you specify a variable here but it is
not included in the output dataset, it means that it was not available in
the time range for any monitor in the county.}

\item{date_min}{A string with the desired starting date in character, ISO
format ("yyyy-mm-dd"). The dataframe returned will include only stations
that have data for dates including and after the specified date.}

\item{date_max}{A string with the desired ending date in character, ISO
format ("yyyy-mm-dd"). The dataframe returned will include only stations
that have data for dates up to and including the specified date.}

\item{coverage}{A numeric value in the range of 0 to 1 that specifies
the desired percentage coverage for the weather variable (i.e., what
percent of each weather variable must be non-missing to include data from
a monitor when calculating daily values averaged across monitors. The
default is to include all monitors with any available data (i.e.,
\code{coverage = 0}).)}
}
\value{
A dataframe of daily weather data averaged across multiple stations for each county in list.
}
\description{
Retrieve average daily weather data for a list of US counties.
}
\note{
The function uses the NOAA API to identify the weather monitors within a U.S. county, you will need to get an access token from
   NOAA to use this function. Visit NOAA's token request page (\url{https://www.ncdc.noaa.gov/cdo-web/token}) to request a token by
   email. You then need to set that API code in your R session (e.g., using \code{options(noaakey = "your key")}, replacing "your key"
   with the API key you've requested from NOAA).
}
\examples{
\dontrun{
climate <- daily_climate_counties(fips_list = c('06001', '06003'),
                                  var = c('prcp', 'snow', 'snwd', 'tmax', 'tmin'),
                                  date_min = '2015-01-01',
                                  date_max = '2015-12-31',
                                  coverage = 0.90)
}

}
