% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{master}
\alias{master}
\title{Master dataset combining the wildfires, AQI, and climate data for California from 2011 through 2015}
\format{A dataframe with 1105972 rows and 23 variables:
\describe{
  \item{FIRE_NAME}{Name of the incident, from the fire report (primary) or ICS-209 report (secondary)}
  \item{DISCOVER_DATE}{Date on which the fire was discovered or confirmed to exist}
  \item{CONT_DATE}{Date on which the fire was declared contained or otherwise controlled}
  \item{STAT_CAUSE_DESCR}{Description of the (statistical) cause of the fire}

  \item{FIRE_SIZE}{Estimate of acres within the final perimeter of the fire}
  \item{FIRE_SIZE_CLASS}{Code for fire size based on the number of acres within the final fire
                         perimeter expenditures (A=greater than 0 but less than or equal to 0.25 acres,
                         B=0.26-9.9 acres, C=10.0-99.9 acres, D=100-299 acres, E=300 to 999 acres,
                         F=1000 to 4999 acres, and G=5000+ acres)}
  \item{LATITUDE}{Latitude (NAD83) for point location of the fire (decimal degrees)}
  \item{LONGITUDE}{Longitude (NAD83) for point location of the fire (decimal degrees)}
  \item{STATE}{Two-letter alphabetic code for the state in which the fire burned}
  \item{FIPS_NAME}{County name from the FIPS publication 6-4 for representation of counties}
  \item{fips}{Five-digit code combining the state and county codes from the FIPS publication 6-4 for counties}
  \item{clim_date}{Date on which the climate measures were recorded}
  \item{prcp}{precipitation, in mm}
  \item{snow}{snowfall, in mm}
  \item{snwd}{snow depth, in	mm}
  \item{tmax}{maximum temperature, in degrees Celsius}
  \item{tmin}{minumum temperature, in degrees Celsius}
  \item{aqi}{AQI level}
  \item{co}{Carbon monoxide, in Parts per million}
  \item{ozone}{Ozone, in Parts per million}
  \item{no2}{Nitrogen dioxide (NO2), in Parts per billion}
  \item{pm25}{PM2.5, in Micrograms/cubic meter (LC)}
  \item{pm10}{PM10, in Micrograms/cubic meter (25 C)}
}}
\usage{
master
}
\description{
The master dataframe takes each wildfire occurrence in California
between 2011 through 2015, and joins the AQI and climate data for 30 days
prior to the DISCOVERY_DATE (fire discovery date) and 30 days post
CONT_DATE (fire contained date). The data is utilized by the Shiny app
to create dashboards.
}
\keyword{datasets}
