% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{w_SearchByIdentifiers}
\alias{w_SearchByIdentifiers}
\title{Search for entities that may match identifiers in a database or authorities'
catalog.}
\usage{
w_SearchByIdentifiers(
  id_list,
  Pauthority,
  langsorder = "",
  nlimit = 3000,
  debug = FALSE
)
}
\arguments{
\item{id_list}{List of identifiers.}

\item{Pauthority}{Wikidata property identifier of the database or
authorities' catalog. For example, if Pauthority = "P4439", then the function
searches for entities that have the identifiers in the MNCARS (Museo Nacional
Centro de Arte Reina Sofía) database. Following library abbreviations for the
databases can be also used in the parameter 'Pauthority':

library   : VIAF, LC,   BNE , ISNI, JPG,  ULAN, BNF,  GND, DNB,
Pauthority: P214, P244, P950, P213, P245, P245, P268, P227, P1292

library   : SUDOC, NTA,  J9U,   ELEM,  NUKAT, MNCARS, RAH
Pauthority: P269, P1006, P8189, P1565, P1207, P4439, P13371}

\item{langsorder}{Order of languages in which the information will be
returned, separated with '|'. If no information is given in the first
language, next is used. If langsorder='', then labels or descriptions are
not returned.}

\item{nlimit}{If the number of entities in the database or authorities'
catalog exceeds this number, then query are made in chunks. The value can
increase if langorder=''. Please, reduce the default value if error is raised.}

\item{debug}{For debugging purposes (default FALSE). If debug='info'
information about chunked queries is shown. If debug='query' also the query
launched is shown. If debug='count' the function only returns the number of
entities with have identifier in that authority.}
}
\value{
A data-frame with columns: 'entity', 'entityLabel', 'entityDescription',
'instanceof', instanceofLabel' and the identifier in the "Pauthority" database.
Index of the data-frame is also set to the list of entities found.
}
\description{
The identifiers are in id_list. The database or authorities' catalog to which
these identifiers belong must be provided in parameter \code{Pauthority}.
If parameter langsorder='', then no labels or descriptions of the entities
are returned, otherwise the function returns them in the language order
indicated in \code{langsorder}. Duplicated entities are deleted before search.
Index of the data-frame returned are also set to id_list.
}
\examples{
\dontrun{
w_SearchByIdentifiers(c("4938246", "36092166", "40787112"), Pauthority='P214')
w_SearchByIdentifiers(c("4938246", "36092166", "40787112"), Pauthority='P214', langsorder='en|fr')
}
}
\author{
Angel Zazo, Department of Computer Science and Automatics, University of Salamanca
}
