% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wconfusionmatrix.R
\name{wconfusionmatrix}
\alias{wconfusionmatrix}
\title{Weighted confusion matrix}
\usage{
wconfusionmatrix(m, weight.type = "arithmetic",
                        weight.penalty = FALSE,
                        standard.deviation = 2,
                        geometric.multiplier = 2,
                        interval.high=1, interval.low = -1,
                        custom.weights = NA,
                        print.weighted.accuracy = FALSE)
}
\arguments{
\item{m}{the caret confusion matrix object or simple matrix.}

\item{weight.type}{the weighting schema to be used. Can be one of:
"arithmetic" - a decreasing arithmetic progression weighting scheme,
"geometric" - a decreasing geometric progression weighting scheme,
"normal" - weights drawn from the right tail of a normal distribution,
"interval" - weights contained on a user-defined interval,
"custom" - custom weight vector defined by the user.}

\item{weight.penalty}{determines whether the weights associated with
non-diagonal elements generated by the "normal", "arithmetic" and "geometric"
weight types are positive or negative values. By default, the value is set to
FALSE, which means that generated weights will be positive values.}

\item{standard.deviation}{standard deviation of the normal distribution, if
the normal distribution weighting schema is used.}

\item{geometric.multiplier}{the multiplier used to construct the geometric
progression series, if the geometric progression weighting scheme is used.}

\item{interval.high}{the upper bound of the weight interval, if the interval
weighting scheme is used.}

\item{interval.low}{the lower bound of the weight interval, if the interval
weighting scheme is used.}

\item{custom.weights}{the vector of custom weight sto be applied, is the
custom weighting scheme wasd selected. The vector should be equal to "n", but
can be larger, with excess values being ignored.}

\item{print.weighted.accuracy}{print the weighted accuracy metric, which
represents the sum of all weighted confusion matrix cells divided by the
total number of observations.}
}
\value{
an nxn weighted confusion matrix
}
\description{
This function calculates the weighted confusion matrix from a caret
ConfusionMatrix object or a simple matrix, according to one of several
weighting schemas and optionally prints the weighted accuracy score.
}
\details{
The number of categories "n" should be greater or equal to 2.
}
\examples{
m = matrix(c(70,0,0,10,10,0,5,3,2), ncol = 3, nrow=3)
wconfusionmatrix(m, weight.type="arithmetic", print.weighted.accuracy = TRUE)
wconfusionmatrix(m, weight.type="geometric", print.weighted.accuracy = TRUE)
wconfusionmatrix(m, weight.type="interval", print.weighted.accuracy = TRUE)
wconfusionmatrix(m, weight.type="normal", print.weighted.accuracy = TRUE)
wconfusionmatrix(m, weight.type= "custom", custom.weights = c(1,0.1,0),
                 print.weighted.accuracy = TRUE)

}
\seealso{
[weightmatrix()]
}
\author{
Alexandru Monahov, <https://www.alexandrumonahov.eu.org/>
}
\keyword{accuracy}
\keyword{confusion}
\keyword{matrix}
\keyword{score}
\keyword{weighted}
