% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlapping_sels.R
\name{overlapping_sels}
\alias{overlapping_sels}
\title{Find overlapping selections}
\usage{
overlapping_sels(
  X,
  index = FALSE,
  pb = TRUE,
  max.ovlp = 0,
  relabel = FALSE,
  drop = FALSE,
  priority = NULL,
  priority.col = NULL,
  indx.row = FALSE,
  parallel = 1,
  verbose = TRUE
)
}
\arguments{
\item{X}{'selection_table' object or data frame with the following columns: 1) "sound.files": name of the sound
files, 2) "selec": number of the selections, 3) "start": start time of selections, 4) "end":
end time of selections.}

\item{index}{Logical. Indicates if only the index of the overlapping selections would be returned.
Default is \code{FALSE}.}

\item{pb}{Logical argument to control progress bar and messages. Default is \code{TRUE}.}

\item{max.ovlp}{Numeric vector of length 1 specifying the maximum overlap allowed (in seconds)
. Default is 0.}

\item{relabel}{Logical. If \code{TRUE} then selection names ('selec' column) are reset within each sound files.
Default is \code{FALSE}.}

\item{drop}{Logical. If \code{TRUE}, when 2 or more selections overlap the function will remove
all but one of the overlapping selection. Default is \code{FALSE}.}

\item{priority}{Character vector. Controls the priority criteria used for removing overlapped selections. It
must list the levels of the column used to determine priority (argument priority.col) in the desired
priority order. Default is \code{NULL}.}

\item{priority.col}{Character vector of length 1 with the name of the column use to determine the priority of
overlapped selections. Default is \code{NULL}.}

\item{indx.row}{Logical. If \code{TRUE} then a character column with the indices of all selections that overlapped with
each selection is added to the ouput data frame (if \code{index = TRUE}). For instance, if the selections in rows 1,2
and 3 all overlapped with each other, the 'indx.row' value would be "1/2/3" for all. However, if selection 3 only overlaps
 with 2 but not with 1, then it returns, "1/2" for row 1, "1/2/3" for row 2, and "2/3" for row 3. Default is \code{FALSE}.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{verbose}{Logical to control if messages are printed to the console.}
}
\value{
A data frame with the columns in X plus an additional column ('ovlp.sels') indicating
which selections overlap. For instance, if the selections in rows 1,2
 overlap and 2 and 3 also overlap, the 'ovlp.sels' label would be the same for all 3 selections. If
\code{drop = TRUE} only the non-overlapping selections are returned.and if 2 or more selections
overlap only the first one is kept. The arguments 'priority' and 'priority.col' can be used to modified the criterium for dropping overlapping selections.
}
\description{
\code{overlapping_sels} finds which selections overlap in time within a given sound file.
}
\details{
This function detects selections within a selection table that overlap in time. Selections must be
listed in a data frame similar to \code{\link{lbh_selec_table}}. Note that row names are set to \code{1:nrow(X)}.
}
\examples{
{
  # no overlap
  overlapping_sels(X = lbh_selec_table)

  # modified lbh_selec_table to make the first and second selection overlap
  Y <- lbh_selec_table
  Y$end[4] <- 1.5

  overlapping_sels(X = Y)

  # drop overlapping
  overlapping_sels(X = Y, drop = TRUE)

  # get index instead
  overlapping_sels(X = Y, index = TRUE)
}
}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link{filter_sels}}, \code{\link{lbh_selec_table}}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
