% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git.R
\name{vsts_get_commits}
\alias{vsts_get_commits}
\title{Visual Studio Project Git Repositories}
\usage{
vsts_get_commits(domain, project, repo, auth_key, query = NULL)
}
\arguments{
\item{domain}{the location of the visual studio server}

\item{project}{the name of the project in \code{domain} to look at}

\item{repo}{the name of the repository in \code{project} to look at}

\item{auth_key}{authentication key generated by using \code{\link{vsts_auth_key}}}

\item{query}{a list of extra parameters that can be sent to the API call:
\describe{
\item{\code{branch}}{[character] the name of a branch in the repository (cannot combine with \code{commit})}
\item{\code{commit}}{[character] the id of a commit in the repository (cannot combine with \code{branch})}
\item{\code{itemPath}}{[character] path of an item in the repository}
\item{\code{committer}}{[character] name of the person who committed the change}
\item{\code{author}}{[character] name of the author}
\item{\code{fromDate}}{[Date] start date to search from}
\item{\code{toDate}}{[Date] end date to search from}
}}
}
\description{
These functions will allow you to scrape git repository information from Visual Studio.
}
\details{
For more information about git repository API calls check
\url{https://docs.microsoft.com/en-us/rest/api/vsts/git/}.
}
\examples{
#Add in own details to get a non-NULL output
auth_key <- vsts_auth_key('<username>', '<password>')
vsts_get_commits('domain', 'project', 'repo', auth_key)

}
