% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{report_counts}
\alias{report_counts}
\title{Create table and plot for categorical variables}
\usage{
report_counts(
  data,
  cols,
  cross = NULL,
  metric = FALSE,
  index = FALSE,
  effect = FALSE,
  numbers = NULL,
  title = TRUE,
  close = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{cols}{A tidy column selection,
e.g. a single column (without quotes)
or multiple columns selected by methods such as starts_with().}

\item{cross}{Optional, a grouping column (without quotes).}

\item{metric}{When crossing variables, the cross column parameter can contain categorical or metric values.
By default, the cross column selection is treated as categorical data.
Set metric to TRUE, to treat it as metric and calculate correlations.}

\item{index}{When the cols contain items on a metric scale
(as determined by \link{get_direction}),
an index will be calculated using the 'psych' package.
Set to FALSE to suppress index generation.}

\item{effect}{Whether to report statistical tests and effect sizes. See \link{effect_counts} for further parameters.}

\item{numbers}{The numbers to print on the bars: "n" (frequency), "p" (percentage) or both.
Set to NULL to remove numbers.}

\item{title}{A character providing the heading or TRUE (default) to output a heading.
Classes for tabset pills will be added.}

\item{close}{Whether to close the last tab (default value TRUE) or to keep it open.
Keep it open to add further custom tabs by adding headers on the fifth level
in Markdown (e.g. ##### Method).}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Parameters passed to the \link{plot_counts} and \link{tab_counts} and \link{effect_counts} functions.}
}
\value{
A volker report object.
}
\description{
Depending on your column selection, different types of plots and tables are generated.
See \link{plot_counts} and \link{tab_counts}.
}
\details{
For item batteries, an index is calculated and reported.
When used in combination with the Markdown-template "html_report",
the different parts of the report are grouped under a tabsheet selector.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
library(volker)
data <- volker::chatgpt

report_counts(data, sd_gender)

}
