% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visGetUtils.R
\name{visGetConnectedNodes}
\alias{visGetConnectedNodes}
\title{Method getConnectedNodes, with shiny only.}
\usage{
visGetConnectedNodes(graph, id, input = paste0(graph$id, "_connectedNodes"))
}
\arguments{
\item{graph}{: a \code{\link{visNetworkProxy}}  object}

\item{id}{: a node or edge id}

\item{input}{: name of shiny input created. Default to paste0(graph$id, "_connectedNodes")}
}
\description{
Method getConnectedNodes, with shiny only. Returns a vector of nodeIds of the all the nodes that are directly connected to this node. If you supply an edgeId, vis will first match the id to nodes.
}
\examples{
\dontrun{

# have a look to : 
shiny::runApp(system.file("shiny", package = "visNetwork"))

}

}
\references{
See online documentation \url{http://datastorm-open.github.io/visNetwork/}
}
\seealso{
\link{visNodes} for nodes options, \link{visEdges} for edges options, \link{visGroups} for groups options, 
\link{visLegend} for adding legend, \link{visOptions} for custom option, \link{visLayout} & \link{visHierarchicalLayout} for layout, 
\link{visPhysics} for control physics, \link{visInteraction} for interaction, \link{visNetworkProxy} & \link{visFocus} & \link{visFit} for animation within shiny,
\link{visDocumentation}, \link{visEvents}, \link{visConfigure} ...
}
