% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_misc.R
\name{ci.fisher}
\alias{ci.fisher}
\title{Fisher confidence interval for any type of correlation.}
\usage{
ci.fisher(alpha, cor, se)
}
\arguments{
\item{alpha}{alpha value for 1-alpha confidence}

\item{cor}{estimate of correlation}

\item{se}{standard error of estimated correlation}
}
\value{
A 2-element vector with lower and upper bounds of the confidence
interval
}
\description{
This function computes a confidence interval for any type
correlation using an estimated correlation and its standard
error. This function should be used with the meta.ave.gen
function when the effect size is a correlation. Use the
estimated average correlation and it standard error from
meta.ave.gen (when the effect size is a correlation) in the
ci.fisher function to obtain a more accurate confidence interval
for the population average correlation.
}
\examples{
ci.fisher(0.05, 0.50, .10)

# Should return:
# [1] 0.2802723 0.6699402


}
