% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_subtract.r
\name{bed_subtract}
\alias{bed_subtract}
\title{Subtract two sets of intervals.}
\usage{
bed_subtract(x, y, any = FALSE)
}
\arguments{
\item{x}{\link{ivl_df}}

\item{y}{\link{ivl_df}}

\item{any}{remove any \code{x} intervals that overlap \code{y}}
}
\description{
Subtract \code{y} intervals from \code{x} intervals.
}
\details{
input tbls are grouped by \code{chrom} by default, and additional
groups can be added using \code{\link[dplyr:group_by]{dplyr::group_by()}}. For example,
grouping by \code{strand} will constrain analyses to the same strand. To
compare opposing strands across two tbls, strands on the \code{y} tbl can
first be inverted using \code{\link[=flip_strands]{flip_strands()}}.
}
\examples{
x <- tibble::tribble(
  ~chrom, ~start, ~end,
  "chr1", 1,      100
)

y <- tibble::tribble(
  ~chrom, ~start, ~end,
  "chr1", 50,     75
)

bed_glyph(bed_subtract(x, y))

x <- tibble::tribble(
  ~chrom, ~start, ~end,
  "chr1", 100,    200,
  "chr1", 250,    400,
  "chr1", 500,    600,
  "chr1", 1000,   1200,
  "chr1", 1300,   1500
)

y <- tibble::tribble(
  ~chrom, ~start, ~end,
  "chr1", 150,    175,
  "chr1", 510,    525,
  "chr1", 550,    575,
  "chr1", 900,    1050,
  "chr1", 1150,   1250,
  "chr1", 1299,   1501
)

bed_subtract(x, y)

bed_subtract(x, y, any = TRUE)

}
\seealso{
\url{https://bedtools.readthedocs.io/en/latest/content/tools/subtract.html}

Other multiple set operations: 
\code{\link{bed_closest}()},
\code{\link{bed_coverage}()},
\code{\link{bed_intersect}()},
\code{\link{bed_map}()},
\code{\link{bed_window}()}
}
\concept{multiple set operations}
