% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coh_match_iterate.R
\name{rematch_}
\alias{rematch_}
\title{Rematch Step for Iterative Match}
\usage{
rematch_(
  all,
  adjusted,
  outcome_date_col,
  censoring_date_col,
  immunization_date_col,
  removed_i,
  vacc_status_col,
  rematch_status,
  control_status,
  nearest,
  exact,
  start_cohort,
  end_cohort,
  im
)
}
\arguments{
\item{all}{\code{data.frame} with the entire cohort.}

\item{adjusted}{\code{data.frame} with the adjusted cohort to calculate
removed cases. Default is NULL, which returns 0.}

\item{outcome_date_col}{Name of the column that contains the outcome dates.}

\item{censoring_date_col}{Name of the column that contains the censoring
date.}

\item{immunization_date_col}{Name of the column that contains the
immunization date to set the beginning of the follow-up period
(\code{t0_follow_up}).}

\item{vacc_status_col}{Name of the column containing the vaccination.}

\item{nearest}{Named vector with name(s) of column(s) for \code{nearest} matching
and caliper(s) for each variable (e.g., \code{nearest = c("characteristic1" = n1, "characteristic2" = n2)}, where \code{n1} and \code{n2} are the calipers).}

\item{exact}{Name(s) of column(s) for \code{exact} matching}

\item{start_cohort}{Start date of the study.}

\item{end_cohort}{End date of the study.}

\item{im}{Iteration number for error message}
}
\value{
List that contains three \code{data.frame}:
\code{adjusted}: updated adjusted matches
\code{adjusted_i_s}: new adjusted matches for \code{rematch_status}
\code{matched_i_s}: all the new matches for \code{rematch_status}
}
\description{
This auxiliary function performs the re-matching strategy for
\code{iterate_match()}. It rematches the population with status given by
\code{rematch_status} and excludes the removed population with status
\code{control_status}. A \code{tryCatch} validation handles errors when no matches
can be generated due to the lack of treated or untreated individuals.
}
\keyword{internal}
