% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utf8-package.R
\docType{package}
\name{utf8-package}
\alias{utf8}
\alias{utf8-package}
\title{The utf8 Package}
\description{
UTF-8 Text Processing
}
\details{
Functions for manipulating and printing UTF-8 encoded text:

\itemize{ \item \code{\link[=as_utf8]{as_utf8()}} attempts to convert character data to
UTF-8, throwing an error if the data is invalid;

\item \code{\link[=utf8_valid]{utf8_valid()}} tests whether character data is valid
according to its declared encoding;

\item \code{\link[=utf8_normalize]{utf8_normalize()}} converts text to Unicode composed normal
form (NFC), optionally applying case-folding and compatibility maps;

\item \code{\link[=utf8_encode]{utf8_encode()}} encodes a character string, escaping all
control characters, so that it can be safely printed to the screen;

\item \code{\link[=utf8_format]{utf8_format()}} formats a character vector by truncating to
a specified character width limit or by left, right, or center justifying;

\item \code{\link[=utf8_print]{utf8_print()}} prints UTF-8 character data to the screen;

\item \code{\link[=utf8_width]{utf8_width()}} measures the display width of UTF-8 character
strings (many emoji and East Asian characters are twice as wide as other
characters);

\item \code{\link[=output_ansi]{output_ansi()}} and \code{\link[=output_utf8]{output_utf8()}} test for the
output connections capabilities. }

For a complete list of functions, use \code{library(help = "utf8")}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://ptrckprry.com/r-utf8/}
  \item \url{https://github.com/patperry/r-utf8}
  \item Report bugs at \url{https://github.com/patperry/r-utf8/issues}
}

}
\author{
\strong{Maintainer}: Kirill Müller \email{kirill@cynkra.com}

Authors:
\itemize{
  \item Patrick O. Perry [copyright holder]
}

Other contributors:
\itemize{
  \item Unicode, Inc. (Unicode Character Database) [copyright holder, data contributor]
}

}
