% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalability.R
\name{limit.scalability,USL-method}
\alias{limit.scalability,USL-method}
\alias{limit.scalability}
\title{Scalability limit of a USL model}
\usage{
\S4method{limit.scalability}{USL}(object, alpha, beta, gamma)
}
\arguments{
\item{object}{A USL object.}

\item{alpha}{Optional parameter to be used for evaluation instead of the
parameter computed for the model.}

\item{beta}{Optional parameter to be used for evaluation instead of the
parameter computed for the model.}

\item{gamma}{Optional parameter to be used for evaluation instead of the
parameter computed for the model.}
}
\value{
A numeric value for the system capacity limit (e.g. throughput).
}
\description{
Calculate the scalability limit for a specific model.
}
\details{
The scalability limit is defined as:

\deqn{Xroof = \frac{\gamma}{\alpha}}{Xroof = \gamma / \alpha}

This is the upper bound (Amdahl asymptote) of system capacity.

The parameters \code{alpha}, \code{beta} and \code{gamma} are useful to do a
what-if analysis. Setting these parameters override the model parameters and
show how the system would behave with a different contention or coherency
delay parameter.

The scalability limit is undefined if \code{alpha} is zero.

This function accepts an argument for \code{beta} although the value is not
required to perform the calculation. This is on purpose to provide a
coherent interface.
}
\examples{
require(usl)

data(specsdm91)

limit.scalability(usl(throughput ~ load, specsdm91))
## The throughput limit is about 3245

}
\seealso{
\code{\link{usl}},
  \code{\link{peak.scalability,USL-method}}
  \code{\link{optimal.scalability,USL-method}}
}
