% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{grad_for_eps}
\alias{grad_for_eps}
\title{Gradient for \code{\link{obj_for_eps}}.}
\usage{
grad_for_eps(parvec, refvec, sizevec, ploidy, mean_bias, var_bias,
  mean_seq, var_seq, mean_od, var_od, wmat, update_bias = TRUE,
  update_seq = TRUE, update_od = TRUE)
}
\arguments{
\item{parvec}{A vector of length three. The first element is the sequencing
error rate, the second element is the allele bias, and the third element
is the overdispersion parameter.}

\item{refvec}{A vector. The ith element is the reference count for the ith individual in the SNP.}

\item{sizevec}{A vector. the ith element is the size count for the ith individual in the SNP/}

\item{ploidy}{The ploidy of the species.}

\item{mean_bias}{The prior mean of the log-bias.}

\item{var_bias}{The prior variance of the log-bias}

\item{mean_seq}{The prior mean of the logit sequencing error rate.}

\item{var_seq}{The prior variance of the logit sequencing error rate.}

\item{mean_od}{The prior mean of the logit of the overdispersion parameter}

\item{var_od}{The prior variance of the logit of the overdispersion parameter.}

\item{wmat}{The matrix of (variational) posterior probabilities for each dosage.
The rows index the individuals and the columns index the dosage levels.}

\item{update_bias}{A logical. This is not used in \code{obj_for_eps},
but sets the second element to \code{0.0} in \code{\link{grad_for_eps}}.}

\item{update_seq}{A logical. This is not used in \code{obj_for_eps},
but sets the first element to \code{0.0} in \code{\link{grad_for_eps}}.}

\item{update_od}{A logical. This is not used in \code{obj_for_eps},
but sets the third element to \code{0.0} in \code{\link{grad_for_eps}}.}
}
\value{
A double.
}
\description{
Gradient for \code{\link{obj_for_eps}}.
}
\author{
David Gerard
}
