% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{convolve_up}
\alias{convolve_up}
\title{Convolution between two discrete probability mass functions
with support on 0:K.}
\usage{
convolve_up(x, y)
}
\arguments{
\item{x}{The first probability vector. The ith element is the
probability of i - 1.}

\item{y}{The second probability vector. The ith element is the
probability of i - 1.}
}
\value{
A vector that is the convolution of \code{x} and
    \code{y}. The ith element is the probability of i - 1.
}
\description{
Convolution between two discrete probability mass functions
with support on 0:K.
}
\examples{
x <- c(1 / 6, 2 / 6, 3 / 6)
y <- c(1 / 9, 2 / 9, 6 / 9)
convolve_up(x, y)
stats::convolve(x, rev(y), type = "o")

}
\seealso{
\code{\link[stats]{convolve}} for a more generic convolution
    function.
}
\author{
David Gerard
}
