% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pp_brent_obj}
\alias{pp_brent_obj}
\title{Objective function when doing Brent's method in
\code{\link{update_pp}} when one parent only has
two mixing components.}
\usage{
pp_brent_obj(firstmixweight, probmat, pvec, weight_vec, alpha)
}
\arguments{
\item{firstmixweight}{The mixing weight of the first component.}

\item{probmat}{The rows index the components and the columns
index the segregation amount. Should only have two rows.}

\item{pvec}{The distribution of the other parent.}

\item{weight_vec}{The weights for each element.}

\item{alpha}{The mixing weight on the uniform component.}
}
\value{
The objective value, as calculated by taking a
    convolution using \code{\link{convolve}} of the mixing
    distribution and \code{pvec}, then putting that
    probability distribution through \code{\link{f1_obj}}.
}
\description{
Objective function when doing Brent's method in
\code{\link{update_pp}} when one parent only has
two mixing components.
}
\author{
David Gerard
}
