% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvmcurve_3trt.R
\name{tvmcurve_3trt}
\alias{tvmcurve_3trt}
\title{Main function for time varying mediation function for continuous outcome and three 
treatment arms (i.e., exposure groups).}
\usage{
tvmcurve_3trt(T1, T2, t.seq, x, y, t.est)
}
\arguments{
\item{T1}{a vector indicating assignment to treatment 1}

\item{T2}{a vector indicating assignment to treatment 2}

\item{t.seq}{a vector of time points for each observation}

\item{x}{matrix of mediator values in wide format}

\item{y}{matrix of outcome values in wide format}

\item{t.est}{time points at which to make the estimation. Default = t.seq}
}
\value{
\item{hat.alpha1}{estimated Treatment 1 effect on mediator}

\item{hat.alpha2}{estimated Treatment 2 effect on mediator}

\item{hat.gamma1}{estimated Treatment 1 direct effect on outcome}

\item{hat.gamma2}{estimated Treatment 2 direct effect on outcome}

\item{hat.tau1}{estimated Treatment 1 total effect on outcome}

\item{hat.tau2}{estimated Treatment 2 total effect on outcome}

\item{hat.beta}{estimated mediator effect on outcome}

\item{hat.mediation1}{time varying mediation effect for Treatment 1 on outcome}

\item{hat.mediation2}{time varying mediation effect for Treatment 2 on outcome}
}
\description{
Part of the set of internal functions to estimate the time-varying mediation effect and 
bootstrap standard errors for three treatment groups and continuous outcome.
}
