% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_all_channel_video_stats.R
\name{get_all_channel_video_stats}
\alias{get_all_channel_video_stats}
\title{Get statistics on all the videos in a Channel}
\usage{
get_all_channel_video_stats(channel_id = NULL, mine = FALSE, ...)
}
\arguments{
\item{channel_id}{Character. Id of the channel}

\item{mine}{Boolean. TRUE if you want to fetch stats of your own channel. Default is FALSE.}

\item{\dots}{Additional arguments passed to \code{\link{tuber_GET}}.}
}
\value{
nested named list with top element names:
\code{kind, etag, id,}
\code{snippet (list of details of the channel including title)}
\code{, statistics (list of 5)}

If the \code{channel_id} is mistyped or there is no information, an empty list is returned
}
\description{
Get statistics on all the videos in a Channel
}
\examples{
\dontrun{

# Set API token via yt_oauth() first

get_all_channel_video_stats(channel_id="UCxOhDvtaoXDAB336AolWs3A")
get_all_channel_video_stats(channel_id="UCMtFAi84ehTSYSE9Xo") # Incorrect channel ID
}
}
\references{
\url{https://developers.google.com/youtube/v3/docs/channels/list}
}
