% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_norm_swminmax.R
\name{ts_norm_swminmax}
\alias{ts_norm_swminmax}
\title{Time Series Sliding Window Min-Max}
\usage{
ts_norm_swminmax(outliers = outliers_boxplot())
}
\arguments{
\item{outliers}{Indicate outliers transformation class. NULL can avoid outliers removal.}
}
\value{
returns a \code{ts_norm_swminmax} object.
}
\description{
The ts_norm_swminmax function creates an object for normalizing a time series based on the "sliding window min-max scaling" method
}
\examples{
# time series to normalize
library(daltoolbox)
data(sin_data)

# convert to sliding windows
ts <- ts_data(sin_data$y, 10)
ts_head(ts, 3)
summary(ts[,10])

# normalization
preproc <- ts_norm_swminmax()
preproc <- fit(preproc, ts)
tst <- transform(preproc, ts)
ts_head(tst, 3)
summary(tst[,10])
}
