% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals_liferegr.R
\name{residuals_liferegr}
\alias{residuals_liferegr}
\title{Residuals for Parametric Regression Models for Failure Time Data}
\usage{
residuals_liferegr(
  object,
  type = c("response", "deviance", "dfbeta", "dfbetas", "working", "ldcase", "ldresp",
    "ldshape", "matrix"),
  collapse = FALSE,
  weighted = (type \%in\% c("dfbeta", "dfbetas"))
)
}
\arguments{
\item{object}{The output from the \code{phregr} call.}

\item{type}{The type of residuals desired, with options including
\code{"response"}, \code{"deviance"}, \code{"dfbeta"},
\code{"dfbetas"}, \code{"working"}, \code{"ldcase"},
\code{"ldresp"}, \code{"ldshape"}, and \code{"matrix"}.}

\item{collapse}{Whether to collapse the residuals by \code{id}.}

\item{weighted}{Whether to compute weighted residuals.}
}
\value{
Either a vector or a matrix of residuals, depending on the specified type:
\itemize{
\item \code{response} residuals are on the scale of the original data.
\item \code{working} residuals are on the scale of the linear predictor.
\item \code{deviance} residuals are on the log-likelihood scale.
\item \code{dfbeta} residuals are returned as a matrix, where the
\eqn{i}-th row represents the approximate change in the model
coefficients resulting from the inclusion of subject \eqn{i}.
\item \code{dfbetas} residuals are similar to \code{dfbeta} residuals, but
each column is scaled by the standard deviation of the
corresponding coefficient.
\item \code{matrix} residuals are a matrix of derivatives of the
log-likelihood function. Let \eqn{L} be the log-likelihood, \eqn{p} be
the linear predictor (\eqn{X\beta}), and \eqn{s} be \eqn{log(\sigma)}.
Then the resulting matrix contains six columns: \eqn{L},
\eqn{\partial L/\partial p}, \eqn{\partial^2 L/\partial p^2},
\eqn{\partial L/\partial s}, \eqn{\partial^2 L/\partial s^2}, and
\eqn{\partial L^2/\partial p\partial s}.
\item \code{ldcase} residulas are likelihood displacement for case weight
perturbation.
\item \code{ldresp} residuals are likelihood displacement for response value
perturbation.
\item \code{ldshape} residuals are likelihood displacement related to the
shape parameter.
}
}
\description{
Obtains the response, deviance, dfbeta, and likelihood
displacement residuals for a parametric regression model for failure
time data.
}
\details{
The algorithms follow the \code{residuals.survreg} function in the
\code{survival} package.
}
\examples{

library(dplyr)

fit1 <- liferegr(
  data = tobin \%>\% mutate(time = ifelse(durable>0, durable, NA)),
  time = "time", time2 = "durable",
  covariates = c("age", "quant"), dist = "normal")

 resid <- residuals_liferegr(fit1, type = "response")

}
\references{
Escobar, L. A. and Meeker, W. Q.
Assessing influence in regression analysis with censored data.
Biometrics 1992; 48:507-528.
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
