% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liferegr.R
\name{liferegr}
\alias{liferegr}
\title{Parametric Regression Models for Failure Time Data}
\usage{
liferegr(
  data,
  rep = "",
  stratum = "",
  time = "time",
  time2 = "",
  event = "event",
  covariates = "",
  weight = "",
  offset = "",
  id = "",
  dist = "weibull",
  robust = FALSE,
  plci = FALSE,
  alpha = 0.05,
  maxiter = 50,
  eps = 1e-09
)
}
\arguments{
\item{data}{The input data frame that contains the following variables:
\itemize{
\item \code{rep}: The replication for by-group processing.
\item \code{stratum}: The stratum.
\item \code{time}: The follow-up time for right censored data, or
the left end of each interval for interval censored data.
\item \code{time2}: The right end of each interval for interval
censored data.
\item \code{event}: The event indicator, 1=event, 0=no event.
\item \code{covariates}: The values of baseline covariates.
\item \code{weight}: The weight for each observation.
\item \code{offset}: The offset for each observation.
\item \code{id}: The optional subject ID to group the score residuals
in computing the robust sandwich variance.
}}

\item{rep}{The name(s) of the replication variable(s) in the input data.}

\item{stratum}{The name(s) of the stratum variable(s) in the input data.}

\item{time}{The name of the time variable or the left end of each
interval for interval censored data in the input data.}

\item{time2}{The name of the right end of each interval for
interval censored data in the input data.}

\item{event}{The name of the event variable in the input data
for right censored data.}

\item{covariates}{The vector of names of baseline covariates
in the input data.}

\item{weight}{The name of the weight variable in the input data.}

\item{offset}{The name of the offset variable in the input data.}

\item{id}{The name of the id variable in the input data.}

\item{dist}{The assumed distribution for time to event. Options include
"exponential", "weibull", "lognormal", and "loglogistic" to be
modeled on the log-scale, and "normal" and "logistic" to be modeled
on the original scale.}

\item{robust}{Whether a robust sandwich variance estimate should be
computed. In the presence of the id variable, the score residuals
will be aggregated for each id when computing the robust sandwich
variance estimate.}

\item{plci}{Whether to obtain profile likelihood confidence interval.}

\item{alpha}{The two-sided significance level.}

\item{maxiter}{The maximum number of iterations.}

\item{eps}{The tolerance to declare convergence.}
}
\value{
A list with the following components:
\itemize{
\item \code{sumstat}: The data frame of summary statistics of model fit
with the following variables:
\itemize{
\item \code{n}: The number of observations.
\item \code{nevents}: The number of events.
\item \code{loglik0}: The log-likelihood under null.
\item \code{loglik1}: The maximum log-likelihood.
\item \code{niter}: The number of Newton-Raphson iterations.
\item \code{dist}: The assumed distribution.
\item \code{p}: The number of parameters, including the intercept,
regression coefficients associated with the covariates, and
the log scale parameters for the strata.
\item \code{nvar}: The number of regression coefficients associated
with the covariates (excluding the intercept).
\item \code{robust}: Whether the robust sandwich variance estimate
is requested.
\item \code{rep}: The replication.
}
\item \code{parest}: The data frame of parameter estimates with the
following variables:
\itemize{
\item \code{param}: The name of the covariate for the parameter estimate.
\item \code{beta}: The parameter estimate.
\item \code{sebeta}: The standard error of parameter estimate.
\item \code{z}: The Wald test statistic for the parameter.
\item \code{expbeta}: The exponentiated parameter estimate.
\item \code{vbeta}: The covariance matrix for parameter estimates.
\item \code{lower}: The lower limit of confidence interval.
\item \code{upper}: The upper limit of confidence interval.
\item \code{p}: The p-value from the chi-square test.
\item \code{method}: The method to compute the confidence interval and
p-value.
\item \code{sebeta_naive}: The naive standard error of parameter estimate
if robust variance is requested.
\item \code{vbeta_naive}: The naive covariance matrix for parameter
estimates if robust variance is requested.
\item \code{rep}: The replication.
}
\item \code{p}: The number of parameters.
\item \code{nvar}: The number of columns of the design matrix excluding
the intercept.
\item \code{param}: The parameter names.
\item \code{beta}: The parameter estimate.
\item \code{vbeta}: The covariance matrix for parameter estimates.
\item \code{vbeta_naive}: The naive covariance matrix for parameter estimates.
\item \code{terms}: The terms object.
\item \code{xlevels}: A record of the levels of the factors used in fitting.
\item \code{data}: The input data.
\item \code{rep}: The name(s) of the replication variable(s).
\item \code{stratum}: The name(s) of the stratum variable(s).
\item \code{time}: The name of the time variable.
\item \code{time2}: The name of the time2 variable.
\item \code{event}: The name of the event variable.
\item \code{covariates}: The names of baseline covariates.
\item \code{weight}: The name of the weight variable.
\item \code{offset}: The name of the offset variable.
\item \code{id}: The name of the id variable.
\item \code{dist}: The assumed distribution for time to event.
\item \code{robust}: Whether a robust sandwich variance estimate should be
computed.
\item \code{plci}: Whether to obtain profile likelihood confidence interval.
\item \code{alpha}: The two-sided significance level.
}
}
\description{
Obtains the parameter estimates from parametric
regression models with uncensored, right censored, left censored, or
interval censored data.
}
\details{
There are two ways to specify the model, one for right censored
data through the time and event variables, and the other for interval
censored data through the time (lower) and time2 (upper) variables.
For the second form, we follow the convention used in SAS PROC LIFEREG:
\itemize{
\item If lower is not missing, upper is not missing, and lower is equal
to upper, then there is no censoring and the event occurred at
time lower.
\item If lower is not missing, upper is not missing, and lower < upper,
then the event time is censored within the interval (lower, upper).
\item If lower is missing, but upper is not missing, then upper will be
used as the left censoring value.
\item If lower is not missing, but upper is missing, then lower will be
used as the right censoring value.
\item If lower is not missing, upper is not missing, but lower > upper,
or if both lower and upper are missing, then the observation will
not be used.
}
}
\examples{

library(dplyr)

# right censored data
(fit1 <- liferegr(
  data = rawdata \%>\% mutate(treat = 1*(treatmentGroup == 1)),
  rep = "iterationNumber", stratum = "stratum",
  time = "timeUnderObservation", event = "event",
  covariates = "treat", dist = "weibull"))

# tobit regression for left censored data
(fit2 <- liferegr(
  data = tobin \%>\% mutate(time = ifelse(durable>0, durable, NA)),
  time = "time", time2 = "durable",
  covariates = c("age", "quant"), dist = "normal"))

}
\references{
John D. Kalbfleisch and Ross L. Prentice.
The Statistical Analysis of Failure Time Data.
Wiley: New York, 1980.
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
