% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{text_parse}
\alias{text_parse}
\title{Parse a snippet of text}
\usage{
text_parse(x, language)
}
\arguments{
\item{x}{\verb{[string]}

The text to parse.}

\item{language}{\verb{[tree_sitter_language]}

The language to parse with.}
}
\value{
A root node.
}
\description{
\code{text_parse()} is a convenience utility for quickly parsing a small snippet
of text using a particular language and getting access to its root node. It
is meant for demonstration purposes. If you are going to need to reparse the
text after an edit has been made, you should create a full parser with
\code{\link[=parser]{parser()}} and use \code{\link[=parser_parse]{parser_parse()}} instead.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
text <- "map(xs, function(x) 1 + 1)"

# Note that this directly returns the root node, not the tree
text_parse(text, language)
\dontshow{\}) # examplesIf}
}
