% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.R
\name{boot}
\alias{boot}
\title{Estimate of confidence intervals of molecular clock parameters with user-supplied set of bootstrap trees}
\usage{
boot(td, tres, ncpu = 1, searchRoot = 1,
  overrideTempConstraint = TRUE, overrideClock = NULL, quiet = TRUE,
  normalApproxTMRCA = FALSE, parallel_foreach = FALSE)
}
\arguments{
\item{td}{A fitted treedater object}

\item{tres}{A list or multiPhylo with bootstrap trees with branches in units of substitutions per site}

\item{ncpu}{Number of threads to use for parallel computation. Recommended.}

\item{searchRoot}{See *dater*}

\item{overrideTempConstraint}{If TRUE (default) will not enforce positive branch lengths in simualtion replicates. Will speed up execution.}

\item{overrideClock}{May be 'strict' or 'additive' or 'relaxed' in which case will force simulations to fit the corresponding model. If ommitted, will inherit the clock model from td}

\item{quiet}{If TRUE will minimize output printed to screen}

\item{normalApproxTMRCA}{If TRUE will use estimate standard deviation from simulation replicates and report confidence interval based on normal distribution}

\item{parallel_foreach}{If TRUE will use the foreach package for parallelization. May work better on HPC systems.}
}
\value{
A list with elements 
\itemize{
\item trees: The fitted treedater objects corresponding to each simulation
\item meanRates: Vector of estimated rates for each simulation
\item meanRate_CI: Confidence interval for substitution rate
\item coef_of_variation_CI: Confidence interval for rate variation
\item timeOfMRCA_CI: Confidence interval for time of common ancestor
}
}
\description{
If the original treedater fit estimated the root position, root
     position will also be estimated for each simulation, so the
     returned trees may have different root positions. Some replicates
     may converge to a strict clock or a relaxed clock, so the
     parameter estimates in each replicate may not be directly
     comparable. It is possible to compute confidence intervals for the
     times of particular nodes or for estimated sample times by
     inspecting the output from each fitted treedater object, which is
     contained in the $trees attribute.
}
\examples{
# simulate a tree 
tre <- ape::rtree(25)
# sample times based on distance from root to tip:
sts <- setNames( ape::node.depth.edgelength( tre )[1:ape::Ntip(tre)], tre$tip.label)
# make a list of trees that simulate outcome of bootstrap using nonparametric phylogeny estimation
# also modify edge length to represent evolutionary distance with rate 1e-3:
bootTrees <- lapply( 1:25, function(i) {
	.tre <- tre
	.tre$edge.length <- tre$edge.length * pmax(rnorm( length(tre$edge.length), 1e-3, 1e-4 ), 0 )
	.tre 
})
tre$edge.length <- tre$edge.length * 1e-3
# run treedater
td <- dater( tre, sts, s= 1000, clock='strict', omega0=.0015  )
# bootstrap: 
( tdboot <- boot( td, bootTrees ) )
# plot lineages through time :
plot( tdboot )


}
\seealso{
dater
parboot
}
\author{
Erik M Volz <erik.volz@gmail.com>
}
