% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interest-rate.R
\name{tr_yield_curve}
\alias{tr_yield_curve}
\title{Daily treasury par yield curve rates}
\source{
\url{https://home.treasury.gov/treasury-daily-interest-rate-xml-feed}
}
\usage{
tr_yield_curve(date = NULL)
}
\arguments{
\item{date}{\code{character(1)} or \code{numeric(1)} date in format yyyy or yyyymm.
If \code{NULL}, all data is returned. Default \code{NULL}.}
}
\value{
A \code{data.frame()} containing the rates or \code{NULL} when no entries were found.
}
\description{
This par yield curve, which relates the par yield on a security to its time to
maturity, is based on the closing market bid prices on the most recently auctioned
Treasury securities in the over-the-counter market. The par yields are derived from
input market prices, which are indicative quotations obtained by the Federal Reserve
Bank of New York at approximately 3:30 PM each business day.
}
\examples{
\donttest{
# get data for a single month
tr_yield_curve("202201")
# or for the entire year
tr_yield_curve(2022)
}
}
\seealso{
Other interest rate: 
\code{\link{tr_bill_rates}()},
\code{\link{tr_long_term_rate}()},
\code{\link{tr_real_long_term}()},
\code{\link{tr_real_yield_curve}()}
}
\concept{interest rate}
