% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth.R
\name{edf_smooth.tramME}
\alias{edf_smooth.tramME}
\title{EDFs of smooth shift terms}
\usage{
\method{edf_smooth}{tramME}(object, ...)
}
\arguments{
\item{object}{A \code{tramME} object.}

\item{...}{Optional arguments passed to the Hessian calculations.}
}
\value{
A named vector with the edf values.
}
\description{
Returns an estimate of effective degrees of freedom associated with each
smooth term.
}
\details{
The EDFs are calculated by summing up the elements of
  \deqn{diag(V_{\vartheta}I)}{diag(VI)} term-by-term.
  \eqn{V_{\vartheta}}{V} is the joint covariance matrix of fixed and random
  parameters (the inverse of the joint precision, i.e., Hessian of the
  negative log-likelihood), and \eqn{I} is the joint precision of the
  unpenalized negative log-likelihood function. See Wood et al. (2016) or
  Wood (2017, Chapter 6) for references.
}
\examples{
data("mcycle", package = "MASS")
fit <- LmME(accel ~ s(times), data = mcycle)
edf_smooth(fit)
}
\references{
Wood, Simon N., Natalya Pya, and Benjamin Saefken (2016).  "Smoothing
  Parameter and Model Selection for General Smooth Models."  Journal of the
  American Statistical Association 111, <doi:10.1080/01621459.2016.1180986>

Wood, Simon N. (2017). Generalized Additive Models: An Introduction with R.
  Second edition. Chapman & Hall/CRC Texts in Statistical Science.
}
