% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SurvregME.R
\name{coef.SurvregME}
\alias{coef.SurvregME}
\title{Extract the coefficients of the fixed effects terms of an SurvregME model.}
\usage{
\method{coef}{SurvregME}(object, as.survreg = FALSE, ...)
}
\arguments{
\item{object}{An \code{SurvregME} object.}

\item{as.survreg}{If \code{TRUE}, return the transformed coefficients as in a
\code{survival::survreg} object.}

\item{...}{Optional arguments passed to \code{coef.tramME}.}
}
\value{
A numeric vector of the transformed coefficients.
}
\description{
Extract the coefficients of the fixed effects terms of an SurvregME model.
}
\examples{
library("survival")
fit <- SurvregME(Surv(time, status) ~ rx + (1 | litter), data = rats)
coef(fit, as.survreg = TRUE)
}
