% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_conv3d}
\alias{torch_conv3d}
\title{Conv3d}
\usage{
torch_conv3d(
  input,
  weight,
  bias = list(),
  stride = 1L,
  padding = 0L,
  dilation = 1L,
  groups = 1L
)
}
\arguments{
\item{input}{input tensor of shape \eqn{(\mbox{minibatch} , \mbox{in\_channels} , iT , iH , iW)}}

\item{weight}{filters of shape \eqn{(\mbox{out\_channels} , \frac{\mbox{in\_channels}}{\mbox{groups}} , kT , kH , kW)}}

\item{bias}{optional bias tensor of shape \eqn{(\mbox{out\_channels})}. Default: NULL}

\item{stride}{the stride of the convolving kernel. Can be a single number or a      tuple \verb{(sT, sH, sW)}. Default: 1}

\item{padding}{implicit paddings on both sides of the input. Can be a      single number or a tuple \verb{(padT, padH, padW)}. Default: 0}

\item{dilation}{the spacing between kernel elements. Can be a single number or      a tuple \verb{(dT, dH, dW)}. Default: 1}

\item{groups}{split input into groups, \eqn{\mbox{in\_channels}} should be divisible by      the number of groups. Default: 1}
}
\description{
Conv3d
}
\section{conv3d(input, weight, bias=NULL, stride=1, padding=0, dilation=1, groups=1) -> Tensor }{


Applies a 3D convolution over an input image composed of several input
planes.

See \code{\link[=nn_conv3d]{nn_conv3d()}} for details and output shape.
}

\examples{
if (torch_is_installed()) {

# filters = torch_randn(c(33, 16, 3, 3, 3))
# inputs = torch_randn(c(20, 16, 50, 10, 20))
# nnf_conv3d(inputs, filters)
}
}
