% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-utils-rnn.R
\name{nn_utils_rnn_pack_sequence}
\alias{nn_utils_rnn_pack_sequence}
\title{Packs a list of variable length Tensors}
\usage{
nn_utils_rnn_pack_sequence(sequences, enforce_sorted = TRUE)
}
\arguments{
\item{sequences}{\code{(list[Tensor])}: A list of sequences of decreasing length.}

\item{enforce_sorted}{(bool, optional): if \code{TRUE}, checks that the input
contains sequences sorted by length in a decreasing order. If
\code{FALSE}, this condition is not checked. Default: \code{TRUE}.}
}
\value{
a \code{PackedSequence} object
}
\description{
\code{sequences} should be a list of Tensors of size \verb{L x *}, where \code{L} is
the length of a sequence and \code{*} is any number of trailing dimensions,
including zero.
}
\details{
For unsorted sequences, use \code{enforce_sorted = FALSE}. If \code{enforce_sorted}
is \code{TRUE}, the sequences should be sorted in the order of decreasing length.
\code{enforce_sorted = TRUE} is only necessary for ONNX export.
}
\examples{
if (torch_is_installed()) {
x <- torch_tensor(c(1,2,3), dtype = torch_long())
y <- torch_tensor(c(4, 5), dtype = torch_long())
z <- torch_tensor(c(6), dtype = torch_long())

p <- nn_utils_rnn_pack_sequence(list(x, y, z))

}
}
