% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_to_sy.R
\name{date_to_sy}
\alias{date_to_sy}
\title{Convert a date value into its school year.}
\usage{
date_to_sy(date_var, last_day_of_sy = NULL)
}
\arguments{
\item{date_var}{the date to convert. Can be a \code{Date} object or a string in the form 'YYYY-MM-DD' or 'MM/DD/YYYY'}

\item{last_day_of_sy}{the cutoff date, after which a date is considered part of the following school year. The year of this argument does not matter. Defaults (noisily) to July 1st.}
}
\value{
Returns a character vector in the format of "2013 - 2014"

A character vector the same length as \code{date_var}
}
\description{
Checks to see if a date is past the user-specified cutoff point for delineating school years, then maps to the appropriate year.
}
\examples{
date_to_sy(as.Date("2014-05-05"), as.Date("2000-07-01"))
date_to_sy(as.Date("2014-07-05"), as.Date("2000-07-01"))

}
