% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutation.R
\name{permutation_test}
\alias{permutation_test}
\title{Compare Two Networks from Sequence Data Using Permutation Tests}
\usage{
permutation_test(
  x,
  y,
  iter = 1000,
  paired = FALSE,
  level = 0.05,
  measures = character(0),
  ...
)
}
\arguments{
\item{x}{A \code{tna} object containing sequence data for the first \code{tna} model.}

\item{y}{A \code{tna} object containing sequence data for the second \code{tna} model.}

\item{iter}{An \code{integer} giving the number of permutations to perform.
The default is 1000.}

\item{paired}{A \code{logical} value. If \code{TRUE}, perform paired permutation tests;
if \code{FALSE}, perform unpaired tests. The default is \code{FALSE}.}

\item{level}{A \code{numeric} value giving the significance level for the
permutation tests. The default is 0.05.}

\item{measures}{A \code{character} vector of centrality measures to test.
See \code{\link[=centralities]{centralities()}} for a list of available centrality measures.}

\item{...}{Additional arguments passed to \code{\link[=centralities]{centralities()}}.}
}
\value{
A \code{tna_permutation} object which is a \code{list} with two elements:
\code{edges} and \code{centralities}, both containing the following elements
\itemize{
\item \code{stats}: A \code{data.frame} of original differences, effect sizes, and
p-values for each edge or centrality measure. The effect size is
computed as the observed difference divided by the standard deviation
of the differences of the permuted samples.
\item \code{diffs_true}: A \code{matrix} of differences in the data.
\item \code{diffs_sig}: A \code{matrix} showing the significant differences.
}
}
\description{
This function compares two networks built from sequence data using
permutation tests. The function builds Markov models for two sequence
objects, computes the transition probabilities, and compares them by
performing permutation tests. It returns the differences in transition
probabilities, effect sizes, p-values, and confidence intervals.
}
\examples{
model_x <- tna(group_regulation[1:200, ])
model_y <- tna(group_regulation[1001:1200, ])
# Small number of iterations for CRAN
permutation_test(model_x, model_y, iter = 20)

}
\seealso{
Evaluation and validation functions
\code{\link{bootstrap}()},
\code{\link{prune}()},
\code{\link{pruning_details}()}
}
\concept{evaluation}
