      SUBROUTINE SGLFREF(INP,IOUT,N,LAGH1,IP,P,P11,P22,C,S,CP11,CP22,
     * CC,CS,R,PH)
C
      INCLUDE 'timsac.h'
C
C     PROGRAM 5.2.3   FREQUENCY RESPONSE FUNCTION (SINGLE CHANNEL)
C-----------------------------------------------------------------------
C      SUBROUTINE SGLARC(C,S,ARC,LAGH1)
C      SUBROUTINE SGLERR(CH,R,N,LAGH1)
C      SUBROUTINE SGLPAC(ARC,PH,LAGH1)
C      SUBROUTINE SPHASE(C,S,PH,LAGH1)
C-----------------------------------------------------------------------
C     ** DESIGNED BY H. AKAIKE, THE INSTITUTE OF STATISTICAL MATHEMATICS
C     ** PROGRAMMED BY E. ARAHATA, THE INSTITUTE OF STATISTICAL MATHEMAT
C         TOKYO
C     ** DATE OF THE LATEST REVISION: MARCH 25, 1977
C     ** THIS PROGRAM WAS ORIGINALLY PUBLISHED IN
C         "DAINAMIKKU SISTEMU NO TOKEI-TEKI KAISEKI TO SEIGYO (STATISTICA
C         ANALYSIS AND CONTROL OF DYNAMIC SYSTEMS)" BY H. AKAIKE AND
C         T. NAKAGAWA, SAIENSU-SHA, TOKYO, 1972 (IN JAPANESE)
C-----------------------------------------------------------------------
C     THIS PROGRAM COMPUTES 1-INPUT,1-OUTPUT FREQUECNY RESPONSE FUNCTION
C     ,GAIN,PHASE,COHERENCY AND RELATIVE ERROR STATISTICS.
C     ONE CARD WITH SPECIFICATION OF INPUT(INP) AND OUTPUT(IOUT)
C     VARIABLE SHOULD BE ADDED ON TOP OF THE OUTPUT OF PROGRAM 5.2.2
C     MULSPE TO FORM THE INPUT TO THIS PROGRAM.
C     WITHIN IP VARIABLES OF MULSPE OUTPUT, INP-TH AND IOUT-TH VARIABLE
C     ARE TAKEN AS INPUT AND OUTPUT VARIABLE.
C
cxx      IMPLICIT REAL*8(A-H,O-Z)
c      DIMENSION P11(501),P22(501),C(501),S(501)
c      DIMENSION R(501),PH(501),P(10,10)
cxx      DIMENSION P11(LAGH1),P22(LAGH1),C(LAGH1),S(LAGH1)
cxx      DIMENSION CP11(LAGH1),CP22(LAGH1),CC(LAGH1),CS(LAGH1)
cxx      DIMENSION R(LAGH1),PH(LAGH1),P(LAGH1,IP,IP)
      INTEGER INP, IOUT, N, LAGH1, IP
      DOUBLE PRECISION P(LAGH1,IP,IP), P11(LAGH1), P22(LAGH1), C(LAGH1),
     1                 S(LAGH1), CP11(LAGH1), CP22(LAGH1), CC(LAGH1),
     2                 CS(LAGH1), R(LAGH1), PH(LAGH1)
c local
      INTEGER I
C     INPUT / OUTPUT DATA FILE OPEN
c      CALL SETWND
c      CALL FLOPN2(NFL)
c      IF (NFL.EQ.0) GO TO 999
C     ABSOLUTE DIMENSION USED FOR SUBROUTINE CALL
c      MJ=10
C     INPUT OUTPUT VARIABLE SPECIFICATION
c      READ(5,1) INP,IOUT
C     READING THE OUTPUT OF PROGRAM 5.2.2 MULSPE
c      READ(5,1) N,LAGH,IP
c      LAGH1=LAGH+1
      DO 5 I=1,LAGH1
c      CALL REMATX(P,IP,IP,1,MJ,MJ)
C     MATRIX REARRANGEMENT
c      P11(I)=P(INP,INP)
c      P22(I)=P(IOUT,IOUT)
      P11(I)=P(I,INP,INP)
      P22(I)=P(I,IOUT,IOUT)
      IF(INP.LT.IOUT) GO TO 7
c      C(I)=P(INP,IOUT)
c      S(I)=-P(IOUT,INP)
      C(I)=P(I,INP,IOUT)
      S(I)=-P(I,IOUT,INP)
      GO TO 5
c    7 C(I)=P(IOUT,INP)
c      S(I)=P(INP,IOUT)
    7 C(I)=P(I,IOUT,INP)
      S(I)=P(I,INP,IOUT)
    5 CONTINUE
C     INITIAL CONDITION PRINT OUT
c      WRITE(6,55)
c      WRITE(6,56)
c      WRITE(6,57) N,LAGH
c      WRITE(6,57) N,LAGH
c      WRITE(6,259) INP,IOUT
c      WRITE(6,58)
c      WRITE(6,59)
c      WRITE(6,159)
c      CALL PRCOL4(P11,P22,C,S,1,LAGH1,1)
C     FREQUENCY RESPONSE FUNCTION COMPUTATION
      DO 10 I=1,LAGH1
c      C(I)=C(I)/P11(I)
c      S(I)=S(I)/P11(I)
c   10 P22(I)=P22(I)/P11(I)
      CC(I)=C(I)/P11(I)
      CS(I)=S(I)/P11(I)
cxx   10 CP22(I)=P22(I)/P11(I)
      CP22(I)=P22(I)/P11(I)
   10 CONTINUE
C     GAIN COMPUTATION
      DO 11 I=1,LAGH1
c      R(I)=C(I)**2+S(I)**2
c   11 P11(I)=DSQRT(R(I))
      R(I)=CC(I)**2+CS(I)**2
cxx   11 CP11(I)=DSQRT(R(I))
      CP11(I)=DSQRT(R(I))
   11 CONTINUE
C     PHASE COMPUTATION
C      CALL SPHASE(C,S,PH,LAGH1)
      CALL SPHASE(CC,CS,PH,LAGH1)
C    COHERENCY COMPUTATION
      DO 12 I=1,LAGH1
c   12 P22(I)=R(I)/P22(I)
cxx   12 CP22(I)=R(I)/CP22(I)
      CP22(I)=R(I)/CP22(I)
   12 CONTINUE
C     RELATIVE ERROR STATISTICS COMPUTATION
c      CALL SGLERR(P22,R,N,LAGH1)
      CALL SGLERR(CP22,R,N,LAGH1)
C     FREQUENCY RESPONSE FUNCTION, GAIN, PHASE, COHERENCY AND RELATIVE
C     ERROR STATISTICS PRINT OUT
c      WRITE(6,60)
c      WRITE(6,61)
c      CALL PRCOL6(C,S,P11,PH,P22,R,1,LAGH1,1)
c	CALL FLCLS2(NFL)
c  999 CONTINUE
c    1 FORMAT(10I5)
c   55 FORMAT(1H ,60HPROGRAM 5.2.3   FREQUENCY RESPONSE FUNCTION (SINGLE
c     ACHANNEL))
c   56 FORMAT(1H ,17HINITIAL CONDITION)
c   57 FORMAT(1H ,2HN=,I5,5X,5HLAGH=,I5)
c   58 FORMAT(1H ,22HINITIAL DATA(SPECTRUM))
c   59 FORMAT(1H ,6X,14HPOWER SPECTRUM,1X,14HPOWER SPECTRUM,3X,11HCO-SPEC
c     ATRUM,1X,13HQUAD-SPECTRUM)
c  159 FORMAT(1H ,4X,1HI,10X,6HP(1,1),8X,6HP(2,2),10X,4HC(I),10X,4HS(I))
c   60 FORMAT(//1H ,4X,1HI,3X,27HFREQUENCY RESPONSE FUNCTION,10X,4HGAIN,9
c     AX,5HPHASE,5X,9HCOHERENCY,6X,8HRELATIVE)
c   61 FORMAT(1H ,12X,9HREAL PART,4X,10HIMAG. PART,51X,5HERROR)
c  259 FORMAT(1H ,6HINPUT=,I5,5X,7HOUTPUT=,I5)
      RETURN
      END SUBROUTINE
C
      SUBROUTINE SGLARC(C,S,ARC,LAGH1)
C     THIS SUBROUTINE COMPUTES RAW PHASES.
C     (SINGLE CHANNEL)
cxx      IMPLICIT REAL*8(A-H,O-Z)
cxx      DIMENSION C(LAGH1),S(LAGH1),ARC(LAGH1)
      INTEGER LAGH1
      DOUBLE PRECISION C(LAGH1), S(LAGH1), ARC(LAGH1)
c local
      INTEGER I
      DOUBLE PRECISION PI, CST5
      PI=3.1415926536
      CST5=0.5D-00
      DO 10 I=1,LAGH1
cc      IF(C(I)) 11,12,13
cc   11 IF(S(I)) 14,15,16
cc   12 IF(S(I)) 17,18,19
      IF(C(I).EQ.0) GO TO 12
      IF(C(I).GT.0) GO TO 13
cxx   11 IF(S(I).LT.0) GO TO 14
      IF(S(I).LT.0) GO TO 14
      IF(S(I).EQ.0) GO TO 15
      IF(S(I).GT.0) GO TO 16
   12 IF(S(I).LT.0) GO TO 17
      IF(S(I).EQ.0) GO TO 18
      IF(S(I).GT.0) GO TO 19
   13 ARC(I)=DATAN(S(I)/C(I))
      GO TO 10
   14 ARC(I)=DATAN(S(I)/C(I))-PI
      GO TO 10
   15 ARC(I)=-PI
      GO TO 10
   16 ARC(I)=DATAN(S(I)/C(I))+PI
      GO TO 10
   17 ARC(I)=-PI*CST5
      GO TO 10
   18 ARC(I)=0.0D-00
      GO TO 10
   19 ARC(I)=PI*CST5
   10 CONTINUE
      RETURN
      END
C
      SUBROUTINE SGLERR(CH,R,N,LAGH1)
C     THIS SUBROUTINE COMPUTES RELATIVE ERROR STATISTICS.
C     (SINGLE CHANNEL)
cxx      IMPLICIT REAL*8(A-H,O-Z)
cxx      DIMENSION CH(LAGH1),R(LAGH1)
      INTEGER N, LAGH1
      DOUBLE PRECISION CH(LAGH1), R(LAGH1)
c local
      INTEGER I, LAGH
      DOUBLE PRECISION D1, D2, CST0, CST1, CST100, E1, ER
C     CONSTANTS D1,D2 COMPUTATION
      LAGH=LAGH1-1
      CALL SUBD12(N,LAGH,1,D1,D2)
C     RELATIVE ERROR STATISTICS COMPUTATION
      CST0=0.0D-00
      CST1=1.0D-00
      CST100=100.0D-00
      DO 20 I=1,LAGH1
      IF(CH(I).LE.CST0) GO TO 22
      IF(CH(I).GT.CST1) GO TO 22
      E1=CST1/CH(I)-CST1
      ER=DSQRT(E1)
      IF(I.EQ.1) GO TO 23
      IF(I.EQ.LAGH1) GO TO 23
      R(I)=D2*ER
      GO TO 20
   23 R(I)=D1*ER
      GO TO 20
   22 R(I)=CST100
   20 CONTINUE
      RETURN
      END
C
      SUBROUTINE SGLPAC(ARC,PH,LAGH1)
C     THIS SUBROUTINE MAKES PHASE CURVE CONTINUOUS.
C     (SINGLE CHANNEL)
cxx      IMPLICIT REAL*8(A-H,O-Z)
cxx      DIMENSION ARC(LAGH1),PH(LAGH1)
      INTEGER LAGH1
      DOUBLE PRECISION ARC(LAGH1), PH(LAGH1)
c local
      INTEGER I
      DOUBLE PRECISION PI, PI2, DK
      PI=3.1415926536
      PI2=PI+PI
      PH(1)=ARC(1)
      DO 10 I=2,LAGH1
      DK=ARC(I)-ARC(I-1)
      IF(DK.GT.PI) GO TO 11
      IF(DK.LT.-PI) GO TO 12
      PH(I)=PH(I-1)+DK
      GO TO 10
   11 PH(I)=PH(I-1)+DK-PI2
      GO TO 10
   12 PH(I)=PH(I-1)+DK+PI2
   10 CONTINUE
      RETURN
      END
C
      SUBROUTINE SPHASE(C,S,PH,LAGH1)
C     THIS SUBROUTINE COMPUTES PHASE.
C     (SINGLE CHANNEL)
cxx      IMPLICIT REAL*8(A-H,O-Z)
cxx      DIMENSION C(LAGH1),S(LAGH1),PH(LAGH1)
c      DIMENSION ARC(501)
cxx      DIMENSION ARC(LAGH1)
      INTEGER LAGH1
      DOUBLE PRECISION C(LAGH1), S(LAGH1), PH(LAGH1)
c local
      DOUBLE PRECISION ARC(LAGH1)
C     ARCTANGENT COMPUTATION
      CALL SGLARC(C,S,ARC,LAGH1)
C     PHASE COMPUTATION
      CALL SGLPAC(ARC,PH,LAGH1)
      RETURN
      END
