% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relocate.R
\name{relocate}
\alias{relocate}
\title{Change column order}
\usage{
relocate(.data, ..., how = "first", where = NULL)
}
\arguments{
\item{.data}{A data.table}

\item{...}{Columns to move}

\item{how}{The mode of movement, including "first","last","after","before".
Default uses "first".}

\item{where}{Destination of columns selected by \code{...}.
Applicable for "after" and "before" mode.}
}
\value{
A data.table with rearranged columns.
}
\description{
Use `relocate()` to change column positions,
 using the same syntax as `select()`. Check similar function
 as `relocate()` in \pkg{dplyr}.
}
\details{
Once you relocate the columns, the order changes forever.
}
\examples{
df <- data.table(a = 1, b = 1, c = 1, d = "a", e = "a", f = "a")
df
df \%>\% relocate(f)
df \%>\% relocate(a,how = "last")

df \%>\% relocate(is.character)
df \%>\% relocate(is.numeric, how = "last")
df \%>\% relocate("[aeiou]")

df \%>\% relocate(a, how = "after",where = f)
df \%>\% relocate(f, how = "before",where = a)
df \%>\% relocate(f, how = "before",where = c)
df \%>\% relocate(f, how = "after",where = c)

df2 <- data.table(a = 1, b = "a", c = 1, d = "a")
df2 \%>\% relocate(is.numeric,
                    how = "after",
                    where = is.character)
df2 \%>\% relocate(is.numeric,
                    how="before",
                    where = is.character)
}
