% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unianova.R
\name{unianova}
\alias{unianova}
\title{Compute one-way ANOVAs}
\usage{
unianova(data, group_var, ..., descriptives = FALSE, post_hoc = FALSE)
}
\arguments{
\item{data}{a \link[tibble:tibble-package]{tibble} or a \link{tdcmm} model}

\item{group_var}{group variable (column name)}

\item{...}{test variables (column names). Leave empty to compute ANOVAs for
all numeric variables in data.}

\item{descriptives}{a logical indicating whether descriptive statistics (mean
& standard deviation) for all group levels should be added to the returned
tibble. Defaults to \code{FALSE}.}

\item{post_hoc}{a logical value indicating whether post-hoc tests should be performed.
Tukey's HSD is employed when the assumption of equal variances is met, whereas the Games-Howell test is
automatically applied when this assumption is violated. The results of the
post-hoc test will be added to a list column in the resulting tibble.}
}
\value{
a \link{tdcmm} model
}
\description{
Computes one-way ANOVAs for one group variable and specified test variables.
If no variables are specified, all numeric (integer or double) variables are
used. A Levene's test will automatically determine whether a classic ANOVA is used.
Otherwise Welch's ANOVA with a (Satterthwaite's) approximation to the degrees of freedom is used.
}
\examples{
WoJ \%>\% unianova(employment, autonomy_selection, autonomy_emphasis)
WoJ \%>\% unianova(employment, descriptives = TRUE, post_hoc = TRUE)
\dontrun{
WoJ \%>\% unianova(employment)
}

}
\concept{ANOVA}
