% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling.R
\name{reverse_scale}
\alias{reverse_scale}
\title{Reverse numeric, logical, or date/time continuous variables}
\usage{
reverse_scale(
  data,
  ...,
  lower_end = NULL,
  upper_end = NULL,
  name = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{data}{A \link[tibble:tibble-package]{tibble} or a \link{tdcmm} model.}

\item{...}{Numeric variables to be reverse scaled. If none are provided,
all numeric columns will be scaled.}

\item{lower_end}{Lower end of provided continuous scale (default is to use
minimum value of current values, which might not be the
actual lower end of the scale).}

\item{upper_end}{Upper end of provided continuous scale (default is to use
maximum value of current values, which might not be the actual upper end of
the scale).}

\item{name}{Optional name for the new reversed variable when a single
variable is provided. By default, the name will be the original variable
name suffixed with \verb{_rev}.}

\item{overwrite}{Logical. If \code{TRUE}, it overwrites the original variable(s)
with the reversed values. If \code{FALSE} (default), a new variable(s) is created.}
}
\value{
A \link{tdcmm} model with the reversed variable(s).
}
\description{
Reverses a continuous scale into a new variable. A 5-1 scale thus turns into
a 1-5 scale. Missing values are retained. For a given continuous variable
the lower and upper end of the scale should be provided. If they are not
provided, the function assumes the scale's minimum and maximum value to
represent these lower/upper ends (and issues a warning about this fact).
This default behavior is prone to errors, however, because a scale may not
include its actual lower and upper ends which might in turn affect correct
reversing. Hence, it is strongly suggested to manually set the lower and
upper bounds of the original continuous scale.
}
\examples{
WoJ \%>\% reverse_scale(autonomy_emphasis, lower_end = 0, upper_end = 1)
WoJ \%>\% reverse_scale(autonomy_emphasis, name = "my_reversed_variable",
lower_end = 0, upper_end = 1)
WoJ \%>\% reverse_scale(overwrite = TRUE)
WoJ \%>\%
  reverse_scale(autonomy_emphasis, lower_end = 0, upper_end = 1) \%>\%
  tab_frequencies(autonomy_emphasis, autonomy_emphasis_rev)
}
\seealso{
Other scaling: 
\code{\link{categorize_scale}()},
\code{\link{center_scale}()},
\code{\link{dummify_scale}()},
\code{\link{minmax_scale}()},
\code{\link{recode_cat_scale}()},
\code{\link{setna_scale}()},
\code{\link{z_scale}()}
}
\concept{scaling}
