% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment_pelt.R
\name{segment_pelt}
\alias{segment_pelt}
\title{Segment a time series using the PELT algorithm}
\usage{
segment_pelt(x, model_fn = fit_meanvar, ...)
}
\arguments{
\item{x}{A time series}

\item{model_fn}{A \code{character} or \code{name} coercible into a \link{fun_cpt} function.
See, for example, \code{\link[=fit_meanshift_norm]{fit_meanshift_norm()}}. The default is \code{\link[=fit_meanvar]{fit_meanvar()}}.}

\item{...}{arguments passed to \code{\link[changepoint:cpt.meanvar]{changepoint::cpt.meanvar()}} or
\code{\link[changepoint:cpt.mean]{changepoint::cpt.mean()}}}
}
\value{
A \code{cpt} object returned by \code{\link[changepoint:cpt.meanvar]{changepoint::cpt.meanvar()}} or
\code{\link[changepoint:cpt.mean]{changepoint::cpt.mean()}}
}
\description{
Segmenting functions for the PELT algorithm
}
\details{
This function wraps either \code{\link[changepoint:cpt.meanvar]{changepoint::cpt.meanvar()}} or
\code{\link[changepoint:cpt.mean]{changepoint::cpt.mean()}}.
}
\examples{
# Segment a time series using PELT
res <- segment_pelt(DataCPSim)
res
str(res)

# Segment as time series while specifying a penalty function
segment_pelt(DataCPSim, penalty = "BIC")

# Segment a time series while specifying a meanshift normal model
segment_pelt(DataCPSim, model_fn = fit_meanshift_norm, penalty = "BIC")

}
