% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_meanshift.R
\name{fit_meanshift}
\alias{fit_meanshift}
\alias{fit_meanshift_norm}
\alias{fit_meanshift_lnorm}
\alias{fit_meanshift_norm_ar1}
\title{Fast implementation of meanshift model}
\usage{
fit_meanshift(x, tau, distribution = "norm", ...)

fit_meanshift_norm(x, tau, ...)

fit_meanshift_lnorm(x, tau, ...)

fit_meanshift_norm_ar1(x, tau, ...)
}
\arguments{
\item{x}{A time series}

\item{tau}{a set of indices representing a changepoint set}

\item{distribution}{A character indicating the distribution of the data.
Should match R distribution function naming conventions
(e.g., "norm" for the Normal distribution, etc.)}

\item{...}{arguments passed to \code{\link[stats:lm]{stats::lm()}}}
}
\value{
A \link{mod_cpt} object.
}
\description{
Fast implementation of meanshift model
}
\details{
\code{\link[=fit_meanshift_norm]{fit_meanshift_norm()}} returns the same model as \code{\link[=fit_lmshift]{fit_lmshift()}} with the
\code{deg_poly} argument set to 0.
However, it is faster on large changepoint sets.

\code{\link[=fit_meanshift_lnorm]{fit_meanshift_lnorm()}} fit the meanshift model with the assumption of
log-normally distributed data.

\code{\link[=fit_meanshift_norm_ar1]{fit_meanshift_norm_ar1()}} applies autoregressive errors.
}
\examples{
# Manually specify a changepoint set
tau <- c(365, 826)

# Fit the model
mod <- fit_meanshift_norm_ar1(DataCPSim, tau)

# View model parameters
logLik(mod)
deg_free(mod)

# Manually specify a changepoint set
cpts <- c(1700, 1739, 1988)
ids <- time2tau(cpts, as_year(time(CET)))

# Fit the model
mod <- fit_meanshift_norm(CET, tau = ids)

# Review model parameters
glance(mod)

# Fit an autoregressive model
mod <- fit_meanshift_norm_ar1(CET, tau = ids)

# Review model parameters
glance(mod)

}
\seealso{
Other model-fitting: 
\code{\link{fit_lmshift}()},
\code{\link{fit_meanvar}()},
\code{\link{fit_nhpp}()},
\code{\link{model_args}()},
\code{\link{model_name}()},
\code{\link{new_fun_cpt}()},
\code{\link{whomademe}()}
}
\author{
Xueheng Shi, Ben Baumer
}
\concept{model-fitting}
