\name{extract}
\alias{extract}
\alias{extract-methods}
\alias{extract.aftreg}
\alias{extract,aftreg-method}
\alias{extract.Arima}
\alias{extract,Arima-method}
\alias{extract.ARIMA}
\alias{extract,ARIMA-method}
\alias{extract.averaging}
\alias{extract,averaging-method}
\alias{extract.bam}
\alias{extract,bam-method}
\alias{extract.betareg}
\alias{extract,betareg-method}
\alias{extract.brglm}
\alias{extract,brglm-method}
\alias{extract.btergm}
\alias{extract,btergm-method}
\alias{extract.censReg}
\alias{extract,censReg-method}
\alias{extract.clm}
\alias{extract,clm-method}
\alias{extract.clogit}
\alias{extract,clogit-method}
\alias{extract.coeftest}
\alias{extract,coeftest-method}
\alias{extract.coxph}
\alias{extract,coxph-method}
\alias{extract.coxph.penal}
\alias{extract,coxph.penal-method}
\alias{extract.dynlm}
\alias{extract,dynlm-method}
\alias{extract.ergm}
\alias{extract,ergm-method}
\alias{extract.ergmm}
\alias{extract,ergmm-method}
\alias{extract.ets}
\alias{extract,ets-method}
\alias{extract.felm}
\alias{extract,felm-method}
\alias{extract.fGARCH}
\alias{extract,fGARCH-method}
\alias{extract.forecast}
\alias{extract,forecast-method}
\alias{extract.gam}
\alias{extract,gam-method}
\alias{extract.gamlss}
\alias{extract,gamlss-method}
\alias{extract.gee}
\alias{extract,gee-method}
\alias{extract.geeglm}
\alias{extract,geeglm-method}
\alias{extract.glm}
\alias{extract,glm-method}
\alias{extract.glmerMod}
\alias{extract,glmerMod-method}
\alias{extract.glmmadmb}
\alias{extract,glmmadmb-method}
\alias{extract.glmmPQL}
\alias{extract,glmmPQL-method}
\alias{extract.glmrob}
\alias{extract,glmrob-method}
\alias{extract.gls}
\alias{extract,gls-method}
\alias{extract.gmm}
\alias{extract,gmm-method}
\alias{extract.hurdle}
\alias{extract,hurdle-method}
\alias{extract.ivreg}
\alias{extract,ivreg-method}
\alias{extract.lm}
\alias{extract,lm-method}
\alias{extract.lme}
\alias{extract,lme-method}
\alias{extract.lme4}
\alias{extract,lme4-method}
\alias{extract.lmerMod}
\alias{extract,lmerMod-method}
\alias{extract.lmrob}
\alias{extract,lmrob-method}
\alias{extract.lnam}
\alias{extract,lnam-method}
\alias{extract.lqmm}
\alias{extract,lqmm-method}
\alias{extract.lrm}
\alias{extract,lrm-method}
\alias{extract.maBina}
\alias{extract,maBina-method}
\alias{extract.mer}
\alias{extract,mer-method}
\alias{extract.mlogit}
\alias{extract,mlogit-method}
\alias{extract.mnlogit}
\alias{extract,mnlogit-method}
\alias{extract.model.selection}
\alias{extract,model.selection-method}
\alias{extract.mtergm}
\alias{extract,mtergm-method}
\alias{extract.multinom}
\alias{extract,multinom-method}
\alias{extract.negbin}
\alias{extract,negbin-method}
\alias{extract.netlogit}
\alias{extract,netlogit-method}
\alias{extract.nlme}
\alias{extract,nlme-method}
\alias{extract.nlmerMod}
\alias{extract,nlmerMod-method}
\alias{extract.ols}
\alias{extract,ols-method}
\alias{extract.pgmm}
\alias{extract,pgmm-method}
\alias{extract.phreg}
\alias{extract,phreg-method}
\alias{extract.plm}
\alias{extract,plm-method}
\alias{extract.pmg}
\alias{extract,pmg-method}
\alias{extract.polr}
\alias{extract,polr-method}
\alias{extract.rem.dyad}
\alias{extract,rem.dyad-method}
\alias{extract.rlm}
\alias{extract,rlm-method}
\alias{extract.rq}
\alias{extract,rq-method}
\alias{extract.sarlm}
\alias{extract,sarlm-method}
\alias{extract.sclm}
\alias{extract,sclm-method}
\alias{extract.selection}
\alias{extract,selection-method}
\alias{extract.sienaFit}
\alias{extract,sienaFit-method}
\alias{extract.simex}
\alias{extract,simex-method}
\alias{extract.stergm}
\alias{extract,stergm-method}
\alias{extract.survreg}
\alias{extract,survreg-method}
\alias{extract.survreg.penal}
\alias{extract,survreg.penal-method}
\alias{extract.svyglm}
\alias{extract,svyglm-method}
\alias{extract.systemfit}
\alias{extract,systemfit-method}
\alias{extract.texreg}
\alias{extract,texreg-method}
\alias{extract.tobit}
\alias{extract,tobit-method}
\alias{extract.weibreg}
\alias{extract,weibreg-method}
\alias{extract.zelig}
\alias{extract,zelig-method}
\alias{extract.Zelig}
\alias{extract,Zelig-method}
\alias{extract.zeroinfl}
\alias{extract,zeroinfl-method}
\docType{methods}
\title{Extract coefficients and GOF measures from a statistical object}
\description{
Extract coefficients and GOF measures from a statistical object.
}
\details{
\code{extract} is a generic function which extracts coefficients and GOF measures from statistical model objects. There are several extract methods for the specific model types, which are called by the generic extract function if it encounters a model known to be handled by the specific method. The output is a \code{texreg} object, which is subsequently used by the \link{texreg} function.
}
\usage{
extract(model, ...)

\S4method{extract}{aftreg}(model, include.loglik = TRUE, 
    include.lr = TRUE, include.nobs = TRUE, include.events = TRUE, 
    include.trisk = TRUE, ...)

\S4method{extract}{Arima}(model, include.pvalues = FALSE, 
    include.aic = TRUE, include.loglik = TRUE, ...)

\S4method{extract}{ARIMA}(model, include.pvalues = FALSE, 
    include.aic = TRUE, include.aicc = TRUE, include.bic = TRUE, 
    include.loglik = TRUE, ...)

\S4method{extract}{averaging}(model, use.ci = FALSE, 
    adjusted.se = FALSE, include.nobs = TRUE, ...)

\S4method{extract}{bam}(model, include.smooth = TRUE, 
    include.aic = TRUE, include.bic = TRUE, 
    include.loglik = TRUE, include.deviance = TRUE, 
    include.dev.expl = TRUE, include.dispersion = TRUE, 
    include.rsquared = TRUE, include.gcv = TRUE, 
    include.nobs = TRUE, include.nsmooth = TRUE, ...)

\S4method{extract}{betareg}(model, include.precision = TRUE, 
    include.pseudors = TRUE, include.loglik = TRUE, 
    include.nobs = TRUE, ...)

\S4method{extract}{brglm}(model, include.aic = TRUE, 
    include.bic = TRUE, include.loglik = TRUE, 
    include.deviance = TRUE, include.nobs = TRUE, ...)

\S4method{extract}{btergm}(model, level = 0.95, 
    include.nobs = TRUE, ...)

\S4method{extract}{censReg}(model, include.aic = TRUE, 
    include.bic = TRUE, include.loglik = TRUE, 
    include.nobs = TRUE, ...)

\S4method{extract}{clm}(model, include.thresholds = TRUE, 
    include.aic = TRUE, include.bic=TRUE, include.loglik = TRUE, 
    include.nobs = TRUE, ...)

\S4method{extract}{clogit}(model, include.aic = TRUE, 
    include.rsquared = TRUE, include.maxrs = TRUE, 
    include.events = TRUE, include.nobs = TRUE, 
    include.missings = TRUE, ...)

\S4method{extract}{coeftest}(model, ...)

\S4method{extract}{coxph}(model, include.aic = TRUE, 
    include.rsquared = TRUE, include.maxrs=TRUE, 
    include.events = TRUE, include.nobs = TRUE, 
    include.missings = TRUE, include.zph = TRUE, ...)

\S4method{extract}{coxph.penal}(model, include.aic = TRUE, 
    include.rsquared = TRUE, include.maxrs = TRUE, 
    include.events = TRUE, include.nobs = TRUE, 
    include.missings = TRUE, include.zph = TRUE, ...)

\S4method{extract}{dynlm}(model, include.rsquared = TRUE, 
    include.adjrs = TRUE, include.nobs = TRUE, 
    include.fstatistic = FALSE, include.rmse = TRUE, ...)

\S4method{extract}{ergm}(model, include.aic = TRUE, 
    include.bic = TRUE, include.loglik = TRUE, ...)

\S4method{extract}{ergmm}(model, include.bic = TRUE, ...)

\S4method{extract}{ets}(model, include.pvalues = FALSE, 
    include.aic = TRUE, include.aicc = TRUE, include.bic = TRUE, 
    include.loglik = TRUE, ...)

\S4method{extract}{felm}(model, include.nobs = TRUE, 
    include.rsquared = TRUE, include.adjrs = TRUE, 
    include.fstatistic = FALSE, ...)

\S4method{extract}{fGARCH}(model, include.nobs = TRUE, 
    include.aic = TRUE, include.loglik = TRUE, ...)

\S4method{extract}{forecast}(model, ...)

\S4method{extract}{gam}(model, include.smooth = TRUE, 
    include.aic = TRUE, include.bic = TRUE, 
    include.loglik = TRUE, include.deviance = TRUE, 
    include.dev.expl = TRUE, include.dispersion = TRUE, 
    include.rsquared = TRUE, include.gcv = TRUE, 
    include.nobs = TRUE, include.nsmooth = TRUE, ...)

\S4method{extract}{gamlss}(model, robust = FALSE, 
    include.nobs = TRUE, include.nagelkerke = TRUE, 
    include.gaic = TRUE, ...)

\S4method{extract}{gee}(model, robust = TRUE, 
    include.dispersion = TRUE, include.nobs = TRUE, ...)

\S4method{extract}{geeglm}(model, include.scale = TRUE, 
    include.correlation = TRUE, include.nobs = TRUE, ...)

\S4method{extract}{glm}(model, include.aic = TRUE, 
    include.bic = TRUE, include.loglik = TRUE, 
    include.deviance = TRUE, include.nobs = TRUE, ...)

\S4method{extract}{glmerMod}(model, method = c("naive", 
    "profile", "boot", "Wald"), level = 0.95, nsim = 1000, 
    include.aic = TRUE, include.bic = TRUE, include.dic = FALSE, 
    include.deviance = FALSE, include.loglik = TRUE, 
    include.nobs = TRUE, include.groups = TRUE, 
    include.variance = TRUE, ...)

\S4method{extract}{glmmadmb}(model, include.variance = TRUE, 
    include.dispersion = TRUE, include.zero = TRUE, 
    include.aic = TRUE, include.bic = TRUE, 
    include.loglik = TRUE, include.nobs = TRUE, 
    include.groups = TRUE, ...)

\S4method{extract}{glmmPQL}(model, include.aic = TRUE, 
    include.bic = TRUE, include.loglik = TRUE, 
    include.nobs = TRUE, include.groups = TRUE, 
    include.variance = FALSE, ...)

\S4method{extract}{glmrob}(model, include.nobs = TRUE, ...)

\S4method{extract}{gls}(model, include.aic = TRUE, 
    include.bic = TRUE, include.loglik = TRUE, 
    include.nobs = TRUE, ...)

\S4method{extract}{gmm}(model, include.obj.fcn = TRUE, 
    include.overidentification = FALSE, include.nobs = TRUE, ...)

\S4method{extract}{hurdle}(model, beside = FALSE, 
    include.count = TRUE, include.zero = TRUE, include.aic = TRUE, 
    include.loglik = TRUE, include.nobs = TRUE, ...)

\S4method{extract}{ivreg}(model, include.rsquared = TRUE, 
    include.adjrs = TRUE, include.nobs = TRUE, 
    include.fstatistic = FALSE, include.rmse = TRUE, ...)

\S4method{extract}{lm}(model, include.rsquared = TRUE, 
    include.adjrs = TRUE, include.nobs = TRUE, 
    include.fstatistic = FALSE, include.rmse = TRUE, ...)

\S4method{extract}{lme}(model, include.aic = TRUE, 
    include.bic = TRUE, include.loglik = TRUE, 
    include.nobs = TRUE, include.groups = TRUE, 
    include.variance = FALSE, ...)

\S4method{extract}{lme4}(model, method = c("naive", 
    "profile", "boot", "Wald"), level = 0.95, nsim = 1000, 
    include.aic = TRUE, include.bic = TRUE, include.dic = FALSE, 
    include.deviance = FALSE, include.loglik = TRUE, 
    include.nobs = TRUE, include.groups = TRUE, 
    include.variance = TRUE, ...)

\S4method{extract}{lmerMod}(model, method = c("naive", 
    "profile", "boot", "Wald"), level = 0.95, nsim = 1000, 
    include.aic = TRUE, include.bic = TRUE, include.dic = FALSE, 
    include.deviance = FALSE, include.loglik = TRUE, 
    include.nobs = TRUE, include.groups = TRUE, 
    include.variance = TRUE, ...)

\S4method{extract}{lmrob}(model, include.nobs = TRUE, ...)

\S4method{extract}{lnam}(model, include.rsquared = TRUE, 
    include.adjrs = TRUE, include.aic = TRUE, include.bic = TRUE, 
    include.loglik = TRUE, ...)

\S4method{extract}{lqmm}(model, include.aic = TRUE, 
    include.bic = TRUE, include.loglik = TRUE, 
    include.nobs = TRUE, include.groups = TRUE, 
    include.tau = FALSE, use.ci = FALSE, beside = TRUE, ...)

\S4method{extract}{lrm}(model, include.pseudors = TRUE, 
    include.lr = TRUE, include.nobs = TRUE, ...)

\S4method{extract}{maBina}(model, ...)

\S4method{extract}{mer}(model, method = c("naive", 
    "profile", "boot", "Wald"), level = 0.95, nsim = 1000, 
    include.aic = TRUE, include.bic = TRUE, include.dic = FALSE, 
    include.deviance = FALSE, include.loglik = TRUE, 
    include.nobs = TRUE, include.groups = TRUE, 
    include.variance = TRUE, ...)

\S4method{extract}{mnlogit}(model, include.aic = TRUE, 
    include.loglik = TRUE, include.nobs = TRUE, 
    include.groups = TRUE, include.intercept = TRUE, 
    include.iterations = FALSE, beside = FALSE, ...)

\S4method{extract}{mlogit}(model, include.aic = TRUE, 
    include.loglik = TRUE, include.nobs = TRUE, ...)

\S4method{extract}{model.selection}(model, include.loglik = TRUE, 
    include.aicc = TRUE, include.delta = TRUE, 
    include.weight = TRUE, include.nobs = TRUE, ...)

\S4method{extract}{mtergm}(model, include.nobs = TRUE, 
    include.aic = TRUE, include.bic = TRUE, include.loglik = TRUE, 
    ...)
    
\S4method{extract}{multinom}(model, include.pvalues = TRUE, 
    include.aic = TRUE, include.bic = TRUE, include.loglik = TRUE, 
    include.deviance = TRUE, include.nobs = TRUE, 
    levels = model$lev, beside = TRUE, ...)

\S4method{extract}{negbin}(model, include.aic = TRUE, 
    include.bic = TRUE, include.loglik = TRUE, 
    include.deviance = TRUE, include.nobs = TRUE, ...)

\S4method{extract}{netlogit}(model, include.aic = TRUE, 
    include.bic = TRUE, include.deviance = TRUE, 
    include.nobs = TRUE, ...)

\S4method{extract}{nlme}(model, include.aic = TRUE, 
    include.bic = TRUE, include.loglik = TRUE, 
    include.nobs = TRUE, include.groups = TRUE, 
    include.variance = FALSE, ...)

\S4method{extract}{nlmerMod}(model, method = c("naive", 
    "profile", "boot", "Wald"), level = 0.95, nsim = 1000, 
    include.aic = TRUE, include.bic = TRUE, include.dic = FALSE, 
    include.deviance = FALSE, include.loglik = TRUE, 
    include.nobs = TRUE, include.groups = TRUE, 
    include.variance = TRUE, ...)

\S4method{extract}{ols}(model, include.nobs = TRUE, 
    include.rsquared = TRUE, include.adjrs = TRUE, 
    include.fstatistic = FALSE, include.lr = TRUE, ...)

\S4method{extract}{pgmm}(model, include.nobs = TRUE, 
    include.sargan = TRUE, include.wald = TRUE, ...)

\S4method{extract}{phreg}(model, include.loglik = TRUE, 
    include.lr = TRUE, include.nobs = TRUE, include.events = TRUE, 
    include.trisk = TRUE, ...)

\S4method{extract}{plm}(model, include.rsquared = TRUE, 
    include.adjrs = TRUE, include.nobs = TRUE, ...)

\S4method{extract}{pmg}(model, include.nobs = TRUE, ...)

\S4method{extract}{polr}(model, include.thresholds = FALSE, 
    include.aic = TRUE, include.bic = TRUE, include.loglik = TRUE, 
    include.deviance = TRUE, include.nobs = TRUE, ...)

\S4method{extract}{rem.dyad}(model, include.nvertices = TRUE, 
    include.events = TRUE, include.aic = TRUE, 
    include.aicc = TRUE, include.bic = TRUE, ...)

\S4method{extract}{rlm}(model, include.nobs = TRUE, ...)

\S4method{extract}{rq}(model, include.nobs = TRUE, 
    include.percentile = TRUE, ...)

\S4method{extract}{sarlm}(model, include.nobs = TRUE, 
    include.aic = TRUE, include.loglik = TRUE, 
    include.wald = TRUE, include.lambda = TRUE, 
    include.rho = TRUE, ...)

\S4method{extract}{sclm}(model, include.thresholds = TRUE, 
    include.aic = TRUE, include.bic = TRUE, include.loglik = TRUE, 
    include.nobs = TRUE, ...)

\S4method{extract}{selection}(model, prefix = TRUE, 
    include.selection = TRUE, include.outcome = TRUE, 
    include.errors = TRUE, include.aic = TRUE, 
    include.bic = TRUE, include.loglik = TRUE, 
    include.rsquared = TRUE, include.adjrs = TRUE, 
    include.nobs = TRUE, ...)

\S4method{extract}{sienaFit}(model, include.iterations = TRUE, 
    ...)

\S4method{extract}{simex}(model, jackknife = TRUE, 
    include.nobs = TRUE, ...)

\S4method{extract}{stergm}(model, beside = FALSE, 
    include.formation = TRUE, include.dissolution = TRUE, 
    include.nvertices = TRUE, include.aic = FALSE, 
    include.bic = FALSE, include.loglik = FALSE, ...)

\S4method{extract}{survreg}(model, include.aic = TRUE, 
    include.bic = TRUE, include.loglik = TRUE, 
    include.deviance = TRUE, include.nobs = TRUE, ...)

\S4method{extract}{survreg.penal}(model, include.aic = TRUE, 
    include.bic = TRUE, include.loglik = TRUE, 
    include.deviance = TRUE, include.nobs = TRUE, ...)

\S4method{extract}{svyglm}(model, include.aic = FALSE, 
    include.bic = FALSE, include.loglik = FALSE, 
    include.deviance = TRUE, include.dispersion = TRUE, 
    include.nobs = TRUE, ...)

\S4method{extract}{systemfit}(model, include.rsquared = TRUE, 
    include.adjrs = TRUE, include.nobs = TRUE, ...)

\S4method{extract}{texreg}(model, ...)

\S4method{extract}{tobit}(model, include.aic = TRUE, 
    include.bic = TRUE, include.loglik = TRUE, 
    include.deviance = TRUE, include.nobs = FALSE, 
    include.censnobs = TRUE, include.wald=TRUE, ...)

\S4method{extract}{weibreg}(model, include.loglik = TRUE, 
    include.lr = TRUE, include.nobs = TRUE, 
    include.events = TRUE, include.trisk = TRUE, ...)

\S4method{extract}{zelig}(model, include.aic = TRUE, 
    include.bic = TRUE, include.loglik = TRUE, 
    include.deviance = TRUE, include.nobs = TRUE, 
    include.rsquared = TRUE, include.adjrs = TRUE, 
    include.fstatistic = TRUE, ...)

\S4method{extract}{Zelig}(model, include.aic = TRUE, 
    include.bic = TRUE, include.loglik = TRUE, 
    include.deviance = TRUE, include.nobs = TRUE, 
    include.censnobs = TRUE, include.wald = TRUE, ...)

\S4method{extract}{zeroinfl}(model, beside = FALSE, 
    include.count = TRUE, include.zero = TRUE, include.aic = TRUE, 
    include.loglik = TRUE, include.nobs = TRUE, ...)
}
\section{Methods}{
\describe{

\item{\code{aftreg}}{
An extract method for aftreg objects from the \pkg{eha} package.
}

\item{\code{Arima}}{
An extract method for Arima objects from the \pkg{stats} package.
}

\item{\code{ARIMA}}{
An extract method for ARIMA objects from the \pkg{forecast} package.
}

\item{\code{averaging}}{
An extract method for averaging objects from the \pkg{MuMIn} package.
}

\item{\code{bam}}{
An extract method for bam objects from the \pkg{mgcv} package.
}

\item{\code{betareg}}{
An extract method for betareg objects from the \pkg{betareg} package.
}

\item{\code{brglm}}{
An extract method for brglm objects from the \pkg{brglm} package.
}

\item{\code{btergm}}{
An extract method for btergm objects from the \pkg{xergm} package.
}

\item{\code{censReg}}{
An extract method for censReg objects from the \pkg{censReg} package.
}

\item{\code{clm}}{
An extract method for clm objects from the \pkg{ordinal} package.
}

\item{\code{clogit}}{
An extract method for clogit objects from the \pkg{survival} package.
}

\item{\code{coeftest}}{
An extract method for coeftest objects from the \pkg{lmtest} package.
}

\item{\code{coxph}}{
An extract method for coxph objects from the \pkg{survival} package.
}

\item{\code{coxph.penal}}{
An extract method for coxph.penal objects from the \pkg{survival} package.
}

\item{\code{dynlm}}{
An extract method for dynlm objects from the \pkg{dynlm} package.
}

\item{\code{ergm}}{
An extract method for ergm objects from the \pkg{ergm} package.
}

\item{\code{ergmm}}{
An extract method for ergmm objects from the \pkg{latentnet} package.
}

\item{\code{ets}}{
An extract method for ets objects from the \pkg{forecast} package.
}

\item{\code{felm}}{
An extract method for felm objects from the \pkg{lfe} package.
}

\item{\code{fGARCH}}{
An extract method for fGARCH objects from the \pkg{fGarch} package.
}

\item{\code{forecast}}{
An extract method for forecast objects from the \pkg{forecast} package.
}

\item{\code{gam}}{
An extract method for gam objects from the \pkg{mgcv} package.
}

\item{\code{gamlss}}{
An extract method for gamlss objects from the \pkg{gamlss} package.
}

\item{\code{gee}}{
An extract method for gee objects from the \pkg{gee} package.
}

\item{\code{geeglm}}{
An extract method for geeglm objects from the \pkg{geepack} package.
}

\item{\code{glm}}{
An extract method for glm objects from the \pkg{stats} package.
}

\item{\code{glmerMod}}{
An extract method for glmerMod objects from the (old) \pkg{lme4} package.
}

\item{\code{glmmadmb}}{
An extract method for glmmadmb objects from the \pkg{glmmADMB} package.
}

\item{\code{glmmPQL}}{
An extract method for glmmPQL objects from the \pkg{MASS} package.
}

\item{\code{glmrob}}{
An extract method for glmrob objects from the \pkg{robustbase} package.
}

\item{\code{gls}}{
An extract method for gls objects from the \pkg{nlme} package.
}

\item{\code{gmm}}{
An extract method for gmm objects from the \pkg{gmm} package.
}

\item{\code{ivreg}}{
An extract method for ivreg objects from the \pkg{AER} package.
}

\item{\code{hurdle}}{
An extract method for hurdle objects from the \pkg{pscl} package.
}

\item{\code{lm}}{
An extract method for lm objects from the \pkg{stats} package.
}

\item{\code{lme}}{
An extract method for lme objects from the \pkg{nlme} package.
}

\item{\code{lme4}}{
An extract method for lme4 objects from the \pkg{lme4} package.
}

\item{\code{lmerMod}}{
An extract method for lmerMod objects from the (old) \pkg{lme4} package.
}

\item{\code{lmrob}}{
An extract method for lmrob objects from the \pkg{robustbase} package.
}

\item{\code{lnam}}{
An extract method for lnam objects from the \pkg{sna} package.
}

\item{\code{lqmm}}{
An extract method for lqmm objects from the \pkg{lqmm} package.
}

\item{\code{lrm}}{
An extract method for lrm objects from the \pkg{Design} or \pkg{rms} package.
}

\item{\code{maBina}}{
An extract method for maBina objects from the \pkg{erer} package.
}

\item{\code{mer}}{
An extract method for mer objects from the (old) \pkg{lme4} package.
}

\item{\code{mlogit}}{
An extract method for mlogit objects from the \pkg{mlogit} package.
}

\item{\code{mnlogit}}{
An extract method for mnlogit objects from the \pkg{mnlogit} package.
}

\item{\code{model.selection}}{
An extract method for model.selection objects from the \pkg{MuMIn} package.
}

\item{\code{mtergm}}{
An extract method for mtergm objects from the \pkg{btergm} package.
}

\item{\code{multinom}}{
An extract method for multinom objects from the \pkg{nnet} package.
}

\item{\code{negbin}}{
An extract method for negbin objects from the \pkg{MASS} package.
}

\item{\code{netlogit}}{
An extract method for netlogit objects from the \pkg{sna} package.
}

\item{\code{nlme}}{
An extract method for nlme objects from the \pkg{nlme} package.
}

\item{\code{nlmerMod}}{
An extract method for nlmerMod objects from the (old) \pkg{lme4} package.
}

\item{\code{ols}}{
An extract method for ols objects from the \pkg{rms} package.
}

\item{\code{pgmm}}{
An extract method for pgmm objects from the \pkg{plm} package.
}

\item{\code{phreg}}{
An extract method for phreg objects from the \pkg{eha} package.
}

\item{\code{plm}}{
An extract method for plm objects from the \pkg{plm} package.
}

\item{\code{pmg}}{
An extract method for pmg objects from the \pkg{plm} package.
}

\item{\code{polr}}{
An extract method for polr objects from the \pkg{MASS} package.
}

\item{\code{rem.dyad}}{
An extract method for rem.dyad objects from the \pkg{relevent} package.
}

\item{\code{rlm}}{
An extract method for rlm objects from the \pkg{MASS} package.
}

\item{\code{rq}}{
An extract method for rq objects from the \pkg{quantreg} package.
}

\item{\code{sarlm}}{
An extract method for sarlm objects from the \pkg{spdep} package.
}

\item{\code{sclm}}{
An extract method for sclm objects from the \pkg{ordinal} package.
}

\item{\code{selection}}{
An extract method for selection objects from the \pkg{sampleSelection} package.
}

\item{\code{sienaFit}}{
An extract method for sienaFit objects from the \pkg{RSiena} package.
}

\item{\code{simex}}{
An extract method for simex objects from the \pkg{simex} package.
}

\item{\code{stergm}}{
An extract method for stergm objects from the \pkg{tergm} package.
}

\item{\code{survreg}}{
An extract method for survreg objects from the \pkg{survival} package.
}

\item{\code{survreg.penal}}{
An extract method for survreg.penal objects from the \pkg{survival} package.
}

\item{\code{svyglm}}{
An extract method for svyglm objects from the \pkg{survey} package.
}

\item{\code{systemfit}}{
An extract method for systemfit objects from the \pkg{systemfit} package.
}

\item{\code{texreg}}{
An extract method for texreg objects from the \pkg{texreg} package. The purpose is to allow for easy manipulation of the output. \code{texreg} objects can be created using the \link{createTexreg} function or using the \link{extract} function. After manipulating the object, it can be handed back to the \link{screenreg}, \link{texreg}, or \link{htmlreg} functions for creating a table.
}

\item{\code{tobit}}{
An extract method for tobit objects from the \pkg{AER} package.
}

\item{\code{weibreg}}{
An extract method for weibreg objects from the \pkg{eha} package.
}

\item{\code{zelig}}{
An extract method for zelig objects from the \pkg{Zelig} package.
}

\item{\code{Zelig}}{
An extract method for Zelig objects from the \pkg{Zelig} package.
}

\item{\code{zeroinfl}}{
An extract method for zeroinfl objects from the \pkg{pscl} package.
}
}
}
\arguments{
\item{model}{ A statistical model object. }
\item{adjusted.se}{ If available: use adjusted rather than default standard errors? }
\item{beside}{ If available: should the model terms be arranged below each other or beside each other? For example, in a stergm model, the formation and dissolution coefficients can be arranged in two columns of the table. }
\item{include.adjrs}{If available: should the adjusted R-squared be reported? }
\item{include.aic}{ If available: should Akaike's information criterion (AIC) be reported? }
\item{include.aicc}{ If available: should AICc be reported? This is a version of AIC with a correction for finite sample sizes. }
\item{include.bic}{ If available: should the Bayesian information criterion (BIC) be reported? }
\item{include.censnobs}{ If available: should the total, right-censored, left-censored, and uncensored number of observations be reported? }
\item{include.correlation}{ If available: should the correlation parameter alpha and its standard error be reported (for geeglm models)? }
\item{include.count}{ If available: should the count model of a zero-inflated or hurdle regression be included in the coefficients block (before the zero-inflation or zero hurdle model)? }
\item{include.delta}{ If available: should the delta statistic be included? }
\item{include.dev.expl}{ If available: should the deviance explained be reported? }
\item{include.deviance}{ If available: should the deviance be reported? }
\item{include.dic}{ If available: should the deviance information criterion (DIC) be reported? }
\item{include.dispersion}{ If available: should the dispersion or scale parameter be reported? }
\item{include.dissolution}{ If available: should the coefficients for the dissolution phase in a STERGM be reported? }
\item{include.errors}{ If available: should the error terms of a sample selection model be reported? }
\item{include.events}{ If available: should the number of events be reported (in survival models)? }
\item{include.formation}{ If available: should the coefficients for the formation phase in a STERGM be reported? }
\item{include.fstatistic}{ If available: should the F statistic be reported? }
\item{include.gaic}{ If available: should the Generalized Akaike's information criterion (GAIC) be reported? }
\item{include.gcv}{ If available: should the GCV score be reported (in GAMs)? }
\item{include.groups}{ If available: should the number of groups in a mixed-effects model (or \code{k} alternatives in a multinomial choice model) be reported? }
\item{include.intercept}{ If available: should the intercept be included in the GOF block? }
\item{include.iterations}{ If available: should the number of iterations be included? }
\item{include.lambda}{ If available: should the lambda statistic and p-value be reported? }
\item{include.loglik}{ If available: should the log-likelihood be reported? }
\item{include.lr}{ If available: should the likelihood ratio test be reported? }
\item{include.maxrs}{If available: should the maximum possible R-squared be reported? }
\item{include.missings}{ If available: should the number of missing observations be reported (in survival models)? }
\item{include.nagelkerke}{ If available: should Nagelkerke's R-squared be reported? }
\item{include.nobs}{ If available: should the number of observations be reported? }
\item{include.nsmooth}{ If available: should the number of smooth terms be reported (in GAMs)? }
\item{include.nvertices}{ If available: should the number of vertices be reported in a statistical network model? }
\item{include.obj.fcn}{ If available: should the value of the objective function (= criterion function) be reported (for \code{gmm} objects)? More precisely, this returns \code{E(g)var(g)^{-1}E(g)}. }
\item{include.outcome}{ If available: should the outcome component of a sample selection model be reported? }
\item{include.overidentification}{ If available: should the J-test for overidentification be reported (for \code{gmm} objects)? }
\item{include.percentile}{ If available: should the percentile (tau) be reported? }
\item{include.precision}{ If available: should the precision estimates of a betareg fit (the phi coefficients) be reported as part of the coefficients block? }
\item{include.pseudors}{ If available: should the pseudo R-squared be reported? }
\item{include.pvalues}{ If available: should the p values be reported (naive p values are not recommended for lme4 models, but see also the \code{mcmc.pvalues} argument)? }
\item{include.rho}{ If available: should the lambda statistic and p-value be reported? }
\item{include.rmse}{ If available: should the root-mean-square error (= residual standard deviation) be reported? }
\item{include.rsquared}{ If available: should R-squared be reported? }
\item{include.sargan}{ If available: should the Sargan test be reported? }
\item{include.scale}{ If available: should the scale parameter gamma and its standard error be reported (for geeglm models)? }
\item{include.selection}{ If available: should the selection component of a sample selection model be reported? }
\item{include.smooth}{ If available: should the smooth terms of a GAM be reported? If they are reported, the EDF value is reported as the coefficient, and DF is included in parentheses (not standard errors because a chi-square test is used for the smooth terms). }
\item{include.tau}{ If available: include tau in linear quantile mixed models? }
\item{include.thresholds}{ If available: should the threshold parameters (that is, the intercepts for the class boundaries) be reported in ordinal models? }
\item{include.trisk}{ If available: should the total time at risk be reported (in event-history models)? }
\item{include.variance}{ If available: should group variances be reported? }
\item{include.wald}{ If available: should the Wald statistic be included? }
\item{include.weight}{ If available: should the weight be included? }
\item{include.zero}{ If available: should the zero-inflation model of a zero-inflated regression or the zero hurdle model of a hurdle regression be included in the coefficients block (after the count model)? }
\item{include.zph}{ If available: should the Cox proportional hazards assumption be tested (resulting in a p value indicating whether the proportional hazards assumption of the model is violated)? }
\item{jackknife}{ If available: use Jackknife variance instead of Asymptotic variance. }
\item{level}{Confidence level (\code{1 - alpha}) for computing confidence intervals. }
\item{levels}{ The names of the levels of a multinomial model that should be included in the table. Should be provided as a vector of character strings. }
\item{method}{ The method used to compute confidence intervals or p values. In \pkg{lme4} models, the default value \code{"naive"} computes naive p values while the other methods compute confidence intervals using the \code{confint} function. }
\item{nsim}{ In linear mixed effects models: the MCMC sample size or number of bootstrapping replications on the basis of which confidence intervals are computed (only if the \code{method} argument does not specify \code{"naive"}, which is the default behavior). Note: large values may take considerable computing time. }
\item{prefix}{ Include prefix before the label of the coefficient in order to identify the current model component. }
\item{robust}{ If available: report robust instead of naive standard errors. }
\item{use.ci}{ Use confidence intervals rather than standard errors. }
\item{...}{ Custom parameters which are handed over to subroutines. }
}
\references{
Leifeld, Philip (2013). texreg: Conversion of Statistical Model Output in R to 
LaTeX and HTML Tables. Journal of Statistical Software, 55(8), 1-24.
\url{http://www.jstatsoft.org/v55/i08/}.
}
\seealso{
\code{\link{texreg-package} \link{texreg}}
}
\author{
Philip Leifeld (\url{http://www.philipleifeld.com})
}
\keyword{methods}
