% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abnormal_by_worst_grade.R
\name{abnormal_by_worst_grade}
\alias{abnormal_by_worst_grade}
\alias{count_abnormal_by_worst_grade}
\alias{s_count_abnormal_by_worst_grade}
\alias{a_count_abnormal_by_worst_grade}
\title{Count patients by most extreme post-baseline toxicity grade per direction of abnormality}
\usage{
count_abnormal_by_worst_grade(
  lyt,
  var,
  variables = list(id = "USUBJID", param = "PARAM", grade_dir = "GRADE_DIR"),
  na_str = default_na_str(),
  nested = TRUE,
  ...,
  .stats = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)

s_count_abnormal_by_worst_grade(
  df,
  .var = "GRADE_ANL",
  .spl_context,
  variables = list(id = "USUBJID", param = "PARAM", grade_dir = "GRADE_DIR")
)

a_count_abnormal_by_worst_grade(
  df,
  .var = "GRADE_ANL",
  .spl_context,
  variables = list(id = "USUBJID", param = "PARAM", grade_dir = "GRADE_DIR")
)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout that analyses will be added to.}

\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables.}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{nested}{(\code{flag})\cr whether this layout instruction should be applied within the existing layout structure _if
possible (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split.
underneath analyses, which is not allowed.}

\item{...}{additional arguments for the lower level functions.}

\item{.stats}{(\code{character})\cr statistics to select for the table.

Options are: \verb{'count_fraction', 'count_fraction_fixed_dp'}}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{"auto"} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var, var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{.spl_context}{(\code{data.frame})\cr gives information about ancestor split states
that is passed by \code{rtables}.}
}
\value{
\itemize{
\item \code{count_abnormal_by_worst_grade()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_count_abnormal_by_worst_grade()} to the table layout.
}

\itemize{
\item \code{s_count_abnormal_by_worst_grade()} returns the single statistic \code{count_fraction} with grades 1 to 4 and
"Any" results.
}

\itemize{
\item \code{a_count_abnormal_by_worst_grade()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The analyze function \code{\link[=count_abnormal_by_worst_grade]{count_abnormal_by_worst_grade()}} creates a layout element to count patients by highest (worst)
analysis toxicity grade post-baseline for each direction, categorized by parameter value.

This function analyzes primary analysis variable \code{var} which indicates toxicity grades. Additional
analysis variables that can be supplied as a list via the \code{variables} parameter are \code{id} (defaults to
\code{USUBJID}), a variable to indicate unique subject identifiers, \code{param} (defaults to \code{PARAM}), a variable
to indicate parameter values, and \code{grade_dir} (defaults to \code{GRADE_DIR}), a variable to indicate directions
(e.g. High or Low) for each toxicity grade supplied in \code{var}.

For each combination of \code{param} and \code{grade_dir} levels, patient counts by worst
grade are calculated as follows:
\itemize{
\item \code{1} to \code{4}: The number of patients with worst grades 1-4, respectively.
\item \code{Any}: The number of patients with at least one abnormality (i.e. grade is not 0).
}

Fractions are calculated by dividing the above counts by the number of patients with at least one
valid measurement recorded during treatment.

Pre-processing is crucial when using this function and can be done automatically using the
\code{\link[=h_adlb_abnormal_by_worst_grade]{h_adlb_abnormal_by_worst_grade()}} helper function. See the description of this function for details on the
necessary pre-processing steps.

Prior to using this function in your table layout you must use \code{\link[rtables:split_rows_by]{rtables::split_rows_by()}} to create two row
splits, one on variable \code{param} and one on variable \code{grade_dir}.
}
\section{Functions}{
\itemize{
\item \code{count_abnormal_by_worst_grade()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

\item \code{s_count_abnormal_by_worst_grade()}: Statistics function which counts patients by worst grade.

\item \code{a_count_abnormal_by_worst_grade()}: Formatted analysis function which is used as \code{afun}
in \code{count_abnormal_by_worst_grade()}.

}}
\examples{
library(dplyr)
library(forcats)
adlb <- tern_ex_adlb

# Data is modified in order to have some parameters with grades only in one direction
# and simulate the real data.
adlb$ATOXGR[adlb$PARAMCD == "ALT" & adlb$ATOXGR \%in\% c("1", "2", "3", "4")] <- "-1"
adlb$ANRIND[adlb$PARAMCD == "ALT" & adlb$ANRIND == "HIGH"] <- "LOW"
adlb$WGRHIFL[adlb$PARAMCD == "ALT"] <- ""

adlb$ATOXGR[adlb$PARAMCD == "IGA" & adlb$ATOXGR \%in\% c("-1", "-2", "-3", "-4")] <- "1"
adlb$ANRIND[adlb$PARAMCD == "IGA" & adlb$ANRIND == "LOW"] <- "HIGH"
adlb$WGRLOFL[adlb$PARAMCD == "IGA"] <- ""

# Pre-processing
adlb_f <- adlb \%>\% h_adlb_abnormal_by_worst_grade()

# Map excludes records without abnormal grade since they should not be displayed
# in the table.
map <- unique(adlb_f[adlb_f$GRADE_DIR != "ZERO", c("PARAM", "GRADE_DIR", "GRADE_ANL")]) \%>\%
  lapply(as.character) \%>\%
  as.data.frame() \%>\%
  arrange(PARAM, desc(GRADE_DIR), GRADE_ANL)

basic_table() \%>\%
  split_cols_by("ARMCD") \%>\%
  split_rows_by("PARAM") \%>\%
  split_rows_by("GRADE_DIR", split_fun = trim_levels_to_map(map)) \%>\%
  count_abnormal_by_worst_grade(
    var = "GRADE_ANL",
    variables = list(id = "USUBJID", param = "PARAM", grade_dir = "GRADE_DIR")
  ) \%>\%
  build_table(df = adlb_f)

}
\seealso{
\code{\link[=h_adlb_abnormal_by_worst_grade]{h_adlb_abnormal_by_worst_grade()}} which pre-processes ADLB data frames to be used in
\code{\link[=count_abnormal_by_worst_grade]{count_abnormal_by_worst_grade()}}.
}
\keyword{internal}
