% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxph.R
\name{estimate_coef}
\alias{estimate_coef}
\title{Hazard ratio estimation in interactions}
\usage{
estimate_coef(
  variable,
  given,
  lvl_var,
  lvl_given,
  coef,
  mmat,
  vcov,
  conf_level = 0.95
)
}
\arguments{
\item{variable, given}{(\code{character(2)})\cr names of the two variables in the interaction. We seek the estimation of
the levels of \code{variable} given the levels of \code{given}.}

\item{lvl_var, lvl_given}{(\code{character})\cr corresponding levels given by \code{\link[=levels]{levels()}}.}

\item{coef}{(\code{numeric})\cr vector of estimated coefficients.}

\item{mmat}{(named \code{numeric}) a vector filled with \code{0}s used as a template to obtain the design matrix.}

\item{vcov}{(\code{matrix})\cr variance-covariance matrix of underlying model.}

\item{conf_level}{(\code{proportion})\cr confidence level of estimate intervals.}
}
\value{
A list of matrices (one per level of variable) with rows corresponding to the combinations of
\code{variable} and \code{given}, with columns:
\itemize{
\item \code{coef_hat}: Estimation of the coefficient.
\item \code{coef_se}: Standard error of the estimation.
\item \code{hr}: Hazard ratio.
\item \verb{lcl, ucl}: Lower/upper confidence limit of the hazard ratio.
}
}
\description{
This function estimates the hazard ratios between arms when an interaction variable is given with
specific values.
}
\details{
Given the cox regression investigating the effect of Arm (A, B, C; reference A)
and Sex (F, M; reference Female). The model is abbreviated: y ~ Arm + Sex + Arm x Sex.
The cox regression estimates the coefficients along with a variance-covariance matrix for:
\itemize{
\item b1 (arm b), b2 (arm c)
\item b3 (sex m)
\item b4 (arm b: sex m), b5 (arm c: sex m)
}

Given that I want an estimation of the Hazard Ratio for arm C/sex M, the estimation
will be given in reference to arm A/Sex M by exp(b2 + b3 + b5)/ exp(b3) = exp(b2 + b5),
therefore the interaction coefficient is given by b2 + b5 while the standard error is obtained
as $1.96 * sqrt(Var b2 + Var b5 + 2 * covariance (b2,b5))$ for a confidence level of 0.95.
}
\examples{
library(dplyr)
library(survival)

ADSL <- tern_ex_adsl \%>\%
  filter(SEX \%in\% c("F", "M"))

adtte <- tern_ex_adtte \%>\% filter(PARAMCD == "PFS")
adtte$ARMCD <- droplevels(adtte$ARMCD)
adtte$SEX <- droplevels(adtte$SEX)

mod <- coxph(
  formula = Surv(time = AVAL, event = 1 - CNSR) ~ (SEX + ARMCD)^2,
  data = adtte
)

mmat <- stats::model.matrix(mod)[1, ]
mmat[!mmat == 0] <- 0

}
\seealso{
\code{\link[=s_cox_multivariate]{s_cox_multivariate()}}.
}
\keyword{internal}
