% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtables_access.R
\name{rtables_access}
\alias{rtables_access}
\alias{h_row_first_values}
\alias{h_row_counts}
\alias{h_row_fractions}
\alias{h_col_counts}
\alias{h_content_first_row}
\alias{is_leaf_table}
\alias{check_names_indices}
\title{Helper functions for accessing information from \code{rtables}}
\usage{
h_row_first_values(table_row, col_names = NULL, col_indices = NULL)

h_row_counts(table_row, col_names = NULL, col_indices = NULL)

h_row_fractions(table_row, col_names = NULL, col_indices = NULL)

h_col_counts(table, col_names = NULL, col_indices = NULL)

h_content_first_row(table)

is_leaf_table(table)

check_names_indices(table_row, col_names = NULL, col_indices = NULL)
}
\arguments{
\item{table_row}{(\code{TableRow})\cr an analysis row in a occurrence table.}

\item{col_names}{(\code{character})\cr the names of the columns to extract from.}

\item{col_indices}{(\code{integer})\cr the indices of the columns to extract from. If \code{col_names} are provided,
then these are inferred from the names of \code{table_row}. Note that this currently only works well with a single
column split.}

\item{table}{(\code{VTableNodeInfo})\cr an occurrence table or row.}
}
\value{
\itemize{
\item \code{h_row_first_values()} returns a \code{vector} of numeric values.
}

\itemize{
\item \code{h_row_counts()} returns a \code{vector} of numeric values.
}

\itemize{
\item \code{h_row_fractions()} returns a \code{vector} of proportions.
}

\itemize{
\item \code{h_col_counts()} returns a \code{vector} of column counts.
}

\itemize{
\item \code{h_content_first_row()} returns a row from an \code{rtables} table.
}

\itemize{
\item \code{is_leaf_table()} returns a \code{logical} value indicating whether current table is a leaf.
}

\itemize{
\item \code{check_names_indices} returns column indices.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

These are a couple of functions that help with accessing the data in \code{rtables} objects.
Currently these work for occurrence tables, which are defined as having a count as the first
element and a fraction as the second element in each cell.
}
\section{Functions}{
\itemize{
\item \code{h_row_first_values()}: Helper function to extract the first values from each content
cell and from specified columns in a \code{TableRow}. Defaults to all columns.

\item \code{h_row_counts()}: Helper function that extracts row values and checks if they are
convertible to integers (\code{integerish} values).

\item \code{h_row_fractions()}: Helper function to extract fractions from specified columns in a \code{TableRow}.
More specifically it extracts the second values from each content cell and checks it is a fraction.

\item \code{h_col_counts()}: Helper function to extract column counts from specified columns in a table.

\item \code{h_content_first_row()}: Helper function to get first row of content table of current table.

\item \code{is_leaf_table()}: Helper function which says whether current table is a leaf in the tree.

\item \code{check_names_indices()}: Internal helper function that tests standard inputs for column indices.

}}
\examples{
tbl <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("RACE") \%>\%
  analyze("AGE", function(x) {
    list(
      "mean (sd)" = rcell(c(mean(x), sd(x)), format = "xx.x (xx.x)"),
      "n" = length(x),
      "frac" = rcell(c(0.1, 0.1), format = "xx (xx)")
    )
  }) \%>\%
  build_table(tern_ex_adsl) \%>\%
  prune_table()
tree_row_elem <- collect_leaves(tbl[2, ])[[1]]
result <- max(h_row_first_values(tree_row_elem))
result

# Row counts (integer values)
# h_row_counts(tree_row_elem) # Fails because there are no integers
# Using values with integers
tree_row_elem <- collect_leaves(tbl[3, ])[[1]]
result <- h_row_counts(tree_row_elem)
# result

# Row fractions
tree_row_elem <- collect_leaves(tbl[4, ])[[1]]
h_row_fractions(tree_row_elem)

}
\seealso{
\link{prune_occurrences} for usage of these functions.
}
\keyword{internal}
