% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_variables.R
\name{control_analyze_vars}
\alias{control_analyze_vars}
\alias{control_summarize_vars}
\title{Control Function for Descriptive Statistics}
\usage{
control_analyze_vars(
  conf_level = 0.95,
  quantiles = c(0.25, 0.75),
  quantile_type = 2,
  test_mean = 0
)
}
\arguments{
\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{quantiles}{(\code{numeric})\cr of length two to specify the quantiles to calculate.}

\item{quantile_type}{(\code{numeric})\cr between 1 and 9 selecting quantile algorithms to be used.
Default is set to 2 as this matches the default quantile algorithm in SAS \verb{proc univariate} set by \code{QNTLDEF=5}.
This differs from R's default. See more about \code{type} in \code{\link[stats:quantile]{stats::quantile()}}.}

\item{test_mean}{(\code{numeric})\cr to test against the mean under the null hypothesis when calculating p-value.}
}
\value{
A list of components with the same names as the arguments.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Sets a list of parameters for summaries of descriptive statistics. Typically used internally to specify
details for \code{\link[=s_summary]{s_summary()}}. This function family is mainly used by \code{\link[=analyze_vars]{analyze_vars()}}.
}
\note{
Deprecation cycle started for \code{control_summarize_vars} as it is going to renamed into
\code{control_analyze_vars}. Intention is to reflect better the core underlying \code{rtables}
functions; in this case \code{\link[=analyze_vars]{analyze_vars()}} wraps \code{\link[rtables:analyze]{rtables::analyze()}}.
}
