% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individual_patient_plot.R
\name{individual_patient_plot}
\alias{individual_patient_plot}
\alias{g_ipp}
\title{Individual Patient Plots}
\usage{
g_ipp(
  df,
  xvar,
  yvar,
  xlab,
  ylab,
  id_var = "USUBJID",
  title = "Individual Patient Plots",
  subtitle = "",
  caption = NULL,
  add_baseline_hline = FALSE,
  yvar_baseline = "BASE",
  ggtheme = nestcolor::theme_nest(),
  plotting_choices = c("all_in_one", "split_by_max_obs", "separate_by_obs"),
  max_obs_per_plot = 4,
  col = NULL
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{xvar}{(\code{string})\cr time point variable to be plotted on x-axis.}

\item{yvar}{(\code{string})\cr continuous analysis variable to be plotted on y-axis.}

\item{xlab}{(\code{string})\cr plot label for x-axis.}

\item{ylab}{(\code{string})\cr plot label for y-axis.}

\item{id_var}{(\code{string})\cr variable used as patient identifier.}

\item{title}{(\code{string})\cr title for plot.}

\item{subtitle}{(\code{string})\cr subtitle for plot.}

\item{caption}{(\code{character} scalar)\cr optional caption below the plot.}

\item{add_baseline_hline}{(\code{flag})\cr adds horizontal line at baseline y-value on
plot when TRUE.}

\item{yvar_baseline}{(\code{string})\cr variable with baseline values only.
Ignored when \code{add_baseline_hline} is FALSE.}

\item{ggtheme}{(\code{theme})\cr optional graphical theme function as provided
by \code{ggplot2} to control outlook of plot. Use \code{ggplot2::theme()} to tweak the display.}

\item{plotting_choices}{(\code{character})\cr specifies options for displaying
plots. Must be one of "all_in_one", "split_by_max_obs", "separate_by_obs".}

\item{max_obs_per_plot}{(\code{count})\cr Number of observations to be plotted on one
plot. Ignored when \code{plotting_choices} is not "separate_by_obs".}

\item{col}{(\code{character})\cr lines colors.}
}
\value{
A \code{ggplot} object or a list of \code{ggplot} objects.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Line plot(s) displaying trend in patients' parameter values over time is rendered.
Patients' individual baseline values can be added to the plot(s) as reference.
}
\section{Functions}{
\itemize{
\item \code{g_ipp()}: Plotting function for individual patient plots which, depending on user
preference, renders a single graphic or compiles a list of graphics that show trends in individual's parameter
values over time.

}}
\examples{
library(dplyr)
library(nestcolor)

# Select a small sample of data to plot.
adlb <- tern_ex_adlb \%>\%
  filter(PARAMCD == "ALT", !(AVISIT \%in\% c("SCREENING", "BASELINE"))) \%>\%
  slice(1:36)

plot_list <- g_ipp(
  df = adlb,
  xvar = "AVISIT",
  yvar = "AVAL",
  xlab = "Visit",
  ylab = "SGOT/ALT (U/L)",
  title = "Individual Patient Plots",
  add_baseline_hline = TRUE,
  plotting_choices = "split_by_max_obs",
  max_obs_per_plot = 5
)
plot_list

}
\seealso{
Relevant helper function \code{\link[=h_g_ipp]{h_g_ipp()}}.
}
