% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_cumulative.R
\name{h_count_cumulative}
\alias{h_count_cumulative}
\title{Helper Function for \code{\link[=s_count_cumulative]{s_count_cumulative()}}}
\usage{
h_count_cumulative(
  x,
  threshold,
  lower_tail = TRUE,
  include_eq = TRUE,
  na.rm = TRUE,
  .N_col
)
}
\arguments{
\item{x}{(\code{numeric})\cr vector of numbers we want to analyze.}

\item{threshold}{(\code{number})\cr a cutoff value as threshold to count values of \code{x}.}

\item{lower_tail}{(\code{logical})\cr whether to count lower tail, default is \code{TRUE}.}

\item{include_eq}{(\code{logical})\cr whether to include value equal to the \code{threshold} in
count, default is \code{TRUE}.}

\item{na.rm}{(\code{flag})\cr whether \code{NA} values should be removed from \code{x} prior to analysis.}

\item{.N_col}{(\code{count})\cr denominator for fraction calculation.}
}
\value{
A named vector with items:
\itemize{
\item \code{count}: the count of values less than, less or equal to, greater than, or greater or equal to a threshold
of user specification.
\item \code{fraction}: the fraction of the count.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Helper function to calculate count and fraction of \code{x} values in the lower or upper tail given a threshold.
}
\examples{
set.seed(1, kind = "Mersenne-Twister")
x <- c(sample(1:10, 10), NA)
.N_col <- length(x)
h_count_cumulative(x, 5, .N_col = .N_col)
h_count_cumulative(x, 5, lower_tail = FALSE, include_eq = FALSE, na.rm = FALSE, .N_col = .N_col)
h_count_cumulative(x, 0, lower_tail = FALSE, .N_col = .N_col)
h_count_cumulative(x, 100, lower_tail = FALSE, .N_col = .N_col)

}
\seealso{
\link{count_cumulative}
}
