% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_rsp_step.R
\name{fit_rsp_step}
\alias{fit_rsp_step}
\title{Subgroup Treatment Effect Pattern (STEP) Fit for Binary (Response) Outcome}
\usage{
fit_rsp_step(variables, data, control = c(control_step(), control_logistic()))
}
\arguments{
\item{variables}{(named \code{list} of \code{character})\cr list of analysis variables:
needs \code{response}, \code{arm}, \code{biomarker}, and optional \code{covariates} and \code{strata}.}

\item{data}{(\code{data.frame})\cr the dataset containing the variables to summarize.}

\item{control}{(named \code{list})\cr combined control list from \code{\link[=control_step]{control_step()}}
and \code{\link[=control_logistic]{control_logistic()}}.}
}
\value{
A matrix of class \code{step}. The first part of the columns describe the
subgroup intervals used for the biomarker variable, including where the
center of the intervals are and their bounds. The second part of the
columns contain the estimates for the treatment arm comparison.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This fits the Subgroup Treatment Effect Pattern logistic regression models for a binary
(response) outcome. The treatment arm variable must have exactly 2 levels,
where the first one is taken as reference and the estimated odds ratios are
for the comparison of the second level vs. the first one.

The (conditional) logistic regression model which is fit is:

\code{response ~ arm * poly(biomarker, degree) + covariates + strata(strata)}

where \code{degree} is specified by \code{control_step()}.
}
\note{
For the default degree 0 the \code{biomarker} variable is not included in the model.
}
\examples{
# Testing dataset with just two treatment arms.
library(survival)
library(dplyr)

adrs_f <- tern_ex_adrs \%>\%
  filter(
    PARAMCD == "BESRSPI",
    ARM \%in\% c("B: Placebo", "A: Drug X")
  ) \%>\%
  mutate(
    # Reorder levels of ARM to have Placebo as reference arm for Odds Ratio calculations.
    ARM = droplevels(forcats::fct_relevel(ARM, "B: Placebo")),
    RSP = case_when(AVALC \%in\% c("PR", "CR") ~ 1, TRUE ~ 0),
    SEX = factor(SEX)
  )

variables <- list(
  arm = "ARM",
  biomarker = "BMRKR1",
  covariates = "AGE",
  response = "RSP"
)

# Fit default STEP models: Here a constant treatment effect is estimated in each subgroup.
# We use a large enough bandwidth to avoid too small subgroups and linear separation in those.
step_matrix <- fit_rsp_step(
  variables = variables,
  data = adrs_f,
  control = c(control_logistic(), control_step(bandwidth = 0.5))
)
dim(step_matrix)
head(step_matrix)

# Specify different polynomial degree for the biomarker interaction to use more flexible local
# models. Or specify different logistic regression options, including confidence level.
step_matrix2 <- fit_rsp_step(
  variables = variables,
  data = adrs_f,
  control = c(control_logistic(conf_level = 0.9), control_step(bandwidth = 0.6, degree = 1))
)

# Use a global constant model. This is helpful as a reference for the subgroup models.
step_matrix3 <- fit_rsp_step(
  variables = variables,
  data = adrs_f,
  control = c(control_logistic(), control_step(bandwidth = NULL, num_points = 2L))
)

# It is also possible to use strata, i.e. use conditional logistic regression models.
variables2 <- list(
  arm = "ARM",
  biomarker = "BMRKR1",
  covariates = "AGE",
  response = "RSP",
  strata = c("STRATA1", "STRATA2")
)

step_matrix4 <- fit_rsp_step(
  variables = variables2,
  data = adrs_f,
  control = c(control_logistic(), control_step(bandwidth = 0.6))
)

}
\seealso{
\code{\link[=control_step]{control_step()}} and \code{\link[=control_logistic]{control_logistic()}} for the available
customization options.
}
