% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response_subgroups.R
\name{extract_rsp_subgroups}
\alias{extract_rsp_subgroups}
\title{Prepares Response Data for Population Subgroups in Data Frames}
\usage{
extract_rsp_subgroups(
  variables,
  data,
  groups_lists = list(),
  conf_level = 0.95,
  method = NULL,
  label_all = "All Patients"
)
}
\arguments{
\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables.}

\item{data}{(\code{data.frame})\cr the dataset containing the variables to summarize.}

\item{groups_lists}{(named \code{list} of \code{list})\cr optionally contains for each \code{subgroups} variable a
list, which specifies the new group levels via the names and the
levels that belong to it in the character vectors that are elements of the list.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{method}{(\code{string})\cr specifies the test used to calculate the p-value for the difference between
two proportions. For options, see \code{\link[=s_test_proportion_diff]{s_test_proportion_diff()}}. Default is \code{NULL} so no test is performed.}

\item{label_all}{(\code{string})\cr label for the total population analysis.}
}
\value{
A named list of two elements:
\itemize{
\item \code{prop}: A \code{data.frame} containing columns \code{arm}, \code{n}, \code{n_rsp}, \code{prop}, \code{subgroup}, \code{var},
\code{var_label}, and \code{row_type}.
\item \code{or}: A \code{data.frame} containing columns \code{arm}, \code{n_tot}, \code{or}, \code{lcl}, \code{ucl}, \code{conf_level},
\code{subgroup}, \code{var}, \code{var_label}, and \code{row_type}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Prepares response rates and odds ratios for population subgroups in data frames. Simple wrapper
for \code{\link[=h_odds_ratio_subgroups_df]{h_odds_ratio_subgroups_df()}} and \code{\link[=h_proportion_subgroups_df]{h_proportion_subgroups_df()}}. Result is a list of two
\code{data.frames}: \code{prop} and \code{or}. \code{variables} corresponds to the names of variables found in \code{data},
passed as a named \code{list} and requires elements \code{rsp}, \code{arm} and optionally \code{subgroups} and \code{strat}.
\code{groups_lists} optionally specifies groupings for \code{subgroups} variables.
}
\examples{
library(dplyr)
library(forcats)

adrs <- tern_ex_adrs
adrs_labels <- formatters::var_labels(adrs)

adrs_f <- adrs \%>\%
  filter(PARAMCD == "BESRSPI") \%>\%
  filter(ARM \%in\% c("A: Drug X", "B: Placebo")) \%>\%
  droplevels() \%>\%
  mutate(
    # Reorder levels of factor to make the placebo group the reference arm.
    ARM = fct_relevel(ARM, "B: Placebo"),
    rsp = AVALC == "CR"
  )
formatters::var_labels(adrs_f) <- c(adrs_labels, "Response")

# Unstratified analysis.
df <- extract_rsp_subgroups(
  variables = list(rsp = "rsp", arm = "ARM", subgroups = c("SEX", "BMRKR2")),
  data = adrs_f
)
df

# Stratified analysis.
df_strat <- extract_rsp_subgroups(
  variables = list(rsp = "rsp", arm = "ARM", subgroups = c("SEX", "BMRKR2"), strat = "STRATA1"),
  data = adrs_f
)
df_strat

# Grouping of the BMRKR2 levels.
df_grouped <- extract_rsp_subgroups(
  variables = list(rsp = "rsp", arm = "ARM", subgroups = c("SEX", "BMRKR2")),
  data = adrs_f,
  groups_lists = list(
    BMRKR2 = list(
      "low" = "LOW",
      "low/medium" = c("LOW", "MEDIUM"),
      "low/medium/high" = c("LOW", "MEDIUM", "HIGH")
    )
  )
)
df_grouped

}
\seealso{
\link{response_subgroups}
}
