% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_timepoint.R
\name{survival_timepoint}
\alias{survival_timepoint}
\alias{s_surv_timepoint}
\alias{a_surv_timepoint}
\alias{s_surv_timepoint_diff}
\alias{a_surv_timepoint_diff}
\alias{surv_timepoint}
\title{Survival Time Point Analysis}
\usage{
s_surv_timepoint(
  df,
  .var,
  time_point,
  is_event,
  control = control_surv_timepoint()
)

a_surv_timepoint(
  df,
  .var,
  time_point,
  is_event,
  control = control_surv_timepoint()
)

s_surv_timepoint_diff(
  df,
  .var,
  .ref_group,
  .in_ref_col,
  time_point,
  control = control_surv_timepoint(),
  ...
)

a_surv_timepoint_diff(
  df,
  .var,
  .ref_group,
  .in_ref_col,
  time_point,
  control = control_surv_timepoint(),
  ...
)

surv_timepoint(
  lyt,
  vars,
  ...,
  table_names_suffix = "",
  var_labels = "Time",
  show_labels = "visible",
  method = c("surv", "surv_diff", "both"),
  .stats = c("pt_at_risk", "event_free_rate", "rate_ci", "rate_diff", "rate_diff_ci",
    "ztest_pval"),
  .formats = NULL,
  .labels = NULL,
  .indent_mods = if (method == "both") {
     c(rate_diff = 1L, rate_diff_ci = 2L,
    ztest_pval = 2L)
 } else {
     c(rate_diff_ci = 1L, ztest_pval = 1L)
 }
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{time_point}{(\code{number})\cr survival time point of interest.}

\item{is_event}{(\code{logical})\cr \code{TRUE} if event, \code{FALSE} if time to event is censored.}

\item{control}{(\code{list})\cr parameters for comparison details, specified by using the helper function
\code{\link[=control_surv_timepoint]{control_surv_timepoint()}}. Some possible parameter options are:
\itemize{
\item \code{conf_level} (\code{proportion})\cr confidence level of the interval for survival rate.
\item \code{conf_type} (\code{string})\cr confidence interval type. Options are "plain" (default), "log", "log-log",
see more in \code{\link[survival:survfit]{survival::survfit()}}. Note option "none" is no longer supported.
\item \code{time_point} (\code{number})\cr survival time point of interest.
}}

\item{.ref_group}{(\code{data.frame} or \code{vector})\cr the data corresponding to the reference group.}

\item{.in_ref_col}{(\code{logical})\cr \code{TRUE} when working with the reference level, \code{FALSE} otherwise.}

\item{...}{additional arguments for the lower level functions.}

\item{lyt}{(\code{layout})\cr input layout where analyses will be added to.}

\item{vars}{(\code{character})\cr variable names for the primary analysis variable to be iterated over.}

\item{table_names_suffix}{(\code{string})\cr optional suffix for the \code{table_names} used for the \code{rtables} to
avoid warnings from duplicate table names.}

\item{var_labels}{(\code{character})\cr character for label.}

\item{show_labels}{(\code{string})\cr label visibility: one of "default", "visible" and "hidden".}

\item{method}{(\code{string})\cr either \code{surv} (survival estimations),
\code{surv_diff} (difference in survival with the control) or \code{both}.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{vector} of \code{integer})\cr indent modifiers for the labels. Each element of the vector
should be a name-value pair with name corresponding to a statistic specified in \code{.stats} and value the indentation
for that statistic's row label.}
}
\value{
\itemize{
\item \code{s_surv_timepoint()} returns the statistics:
\itemize{
\item \code{pt_at_risk}: Patients remaining at risk.
\item \code{event_free_rate}: Event-free rate (\%).
\item \code{rate_se}: Standard error of event free rate.
\item \code{rate_ci}: Confidence interval for event free rate.
}
}

\itemize{
\item \code{a_surv_timepoint()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}

\itemize{
\item \code{s_surv_timepoint_diff()} returns the statistics:
\itemize{
\item \code{rate_diff}: Event-free rate difference between two groups.
\item \code{rate_diff_ci}: Confidence interval for the difference.
\item \code{ztest_pval}: p-value to test the difference is 0.
}
}

\itemize{
\item \code{a_surv_timepoint_diff()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}

\itemize{
\item \code{surv_timepoint()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_surv_timepoint()} and/or \code{s_surv_timepoint_diff()} to the table layout depending on
the value of \code{method}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Summarize patients' survival rate and difference of survival rates between groups at a time point.
}
\section{Functions}{
\itemize{
\item \code{s_surv_timepoint()}: Statistics function which analyzes survival rate.

\item \code{a_surv_timepoint()}: Formatted analysis function which is used as \code{afun} in \code{surv_timepoint()}
when \code{method = "surv"}.

\item \code{s_surv_timepoint_diff()}: Statistics function which analyzes difference between two survival rates.

\item \code{a_surv_timepoint_diff()}: Formatted analysis function which is used as \code{afun} in \code{surv_timepoint()}
when \code{method = "surv_diff"}.

\item \code{surv_timepoint()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

}}
\examples{
library(dplyr)

adtte_f <- tern_ex_adtte \%>\%
  filter(PARAMCD == "OS") \%>\%
  mutate(
    AVAL = day2month(AVAL),
    is_event = CNSR == 0
  )
df <- adtte_f \%>\%
  filter(ARMCD == "ARM A")

df_ref_group <- adtte_f \%>\%
  filter(ARMCD == "ARM B")

# Survival at given time points.
basic_table() \%>\%
  split_cols_by(var = "ARMCD", ref_group = "ARM A") \%>\%
  add_colcounts() \%>\%
  surv_timepoint(
    vars = "AVAL",
    var_labels = "Months",
    is_event = "is_event",
    time_point = 7
  ) \%>\%
  build_table(df = adtte_f)

# Difference in survival at given time points.
basic_table() \%>\%
  split_cols_by(var = "ARMCD", ref_group = "ARM A") \%>\%
  add_colcounts() \%>\%
  surv_timepoint(
    vars = "AVAL",
    var_labels = "Months",
    is_event = "is_event",
    time_point = 9,
    method = "surv_diff",
    .indent_mods = c("rate_diff" = 0L, "rate_diff_ci" = 2L, "ztest_pval" = 2L)
  ) \%>\%
  build_table(df = adtte_f)

# Survival and difference in survival at given time points.
basic_table() \%>\%
  split_cols_by(var = "ARMCD", ref_group = "ARM A") \%>\%
  add_colcounts() \%>\%
  surv_timepoint(
    vars = "AVAL",
    var_labels = "Months",
    is_event = "is_event",
    time_point = 9,
    method = "both"
  ) \%>\%
  build_table(df = adtte_f)

}
\keyword{internal}
