% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractRegion.R
\name{extractRegion}
\alias{extractRegion}
\title{Extract region from a SpatialGridDataFrame}
\usage{
extractRegion(
  sgdf,
  extent,
  type = "response",
  aggfact = NULL,
  mask = NULL,
  aspect = F,
  aspect.categories = NULL,
  slope = F
)
}
\arguments{
\item{sgdf}{SpatialGridDataFrame containing data to extract}

\item{extent}{raster::extent object featuring region to extract, or a 
SpatialPolygonsXXX object used for extracting areal data}

\item{type}{whether to return the raw data, anomalies (data minus temporal 
average at each location), standardized anomalies (anomalies divided by
temporal standard deviation at each location), or spatially standardized
data (data minus overall spatial average divided by spatial std. dev.; each
year gets its own spatial standardization )}

\item{aggfact}{if provided, will spatially average the data}

\item{mask}{if an sgdf is provided, the data will be masked before
extraction, aggregation, and anomaly computation}

\item{aspect}{TRUE to return the aspect of the surface at each location 
instead of the value of the surface itself}

\item{aspect.categories}{if aspect==TRUE, this specifies the number of 
discrete categories to divide aspect numbers (0-360) into.  NULL if the
original scale (0-360) should be kept. By design, the aspect categories
will be centered on north in the first category.}

\item{slope}{TRUE to return the slope of the surface at each location instead
of the value of the surface itself}
}
\value{
a modified SpatialGridDataFrame, sgdf, with the climatology for each
 location accessible via attr(sgdf@data@values, 'scaled:center') if anomalies
 were computed
}
\description{
This method is intended for use as the main helper function for 
extractStData.
}
