% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{dispersion}
\alias{dispersion}
\alias{circular_distance}
\alias{circular_dispersion}
\alias{circular_sd2}
\title{Circular Distance and Dispersion}
\usage{
circular_distance(x, y, axial = TRUE, na.rm = TRUE)

circular_dispersion(
  x,
  y = NULL,
  w = NULL,
  w.y = NULL,
  axial = TRUE,
  na.rm = TRUE
)

circular_sd2(x, y, w = NULL, axial = TRUE, na.rm = TRUE)
}
\arguments{
\item{x, y}{vectors of numeric values in degrees. \code{length(y)} is either
\code{1} or \code{length(x)}}

\item{axial}{logical. Whether the data are axial, i.e. pi-periodical
(\code{TRUE}, the default) or directional, i.e. \eqn{2 \pi}-periodical (\code{FALSE}).}

\item{na.rm}{logical. Whether \code{NA} values in \code{x}
should be stripped before the computation proceeds.}

\item{w, w.y}{(optional) Weights. A vector of positive numbers and of the same
length as \code{x}. \code{w.y} is the (optional) weight of \code{y}.}
}
\value{
\code{circular_distance} returns a numeric vector of positive numbers,
\code{circular_dispersion} and \code{\link[=circular_sd2]{circular_sd2()}} return a positive number.
}
\description{
Circular distance between two angles and circular dispersion of angles
about a specified angle.
}
\details{
Circular dispersion is a measure for the spread of data like the variance.
Dispersion measures the spread about a given angles, whereas
the variance measures the spread about the mean (Mardia and Jupp, 1999). When
\code{y = NULL} the dispersion is identical to the variance.

Circular standard deviation in \code{\link[=circular_sd2]{circular_sd2()}} is the transformed dispersion
instead of the variance as for \code{\link[=circular_sd]{circular_sd()}}.
}
\note{
If \code{y} is \code{NULL}, than the circular variance is returned.
}
\examples{
a <- c(0, 2, 359, 6, 354)
circular_distance(a, 10) # distance to single value

b <- a + 90
circular_distance(a, b) # distance to multiple values

data("nuvel1")
PoR <- subset(nuvel1, nuvel1$plate.rot == "na")
sa.por <- PoR_shmax(san_andreas, PoR, "right")
circular_dispersion(sa.por$azi.PoR, y = 135)
circular_dispersion(sa.por$azi.PoR, y = 135, w = 1 / san_andreas$unc)
circular_sd2(sa.por$azi.PoR, y = 135, w = 1 / san_andreas$unc)
}
\references{
Mardia, K.V. (1972). Statistics of Directional Data: Probability
and Mathematical Statistics. London: Academic Press.

Mardia, K.V., and Jupp, P.E (1999). Directional Statistics,
Wiley Series in Probability and Statistics. John Wiley & Sons, Inc.,
Hoboken, NJ, USA. \doi{10.1002/9780470316979}
}
\seealso{
\code{\link[=circular_mean]{circular_mean()}}, \code{\link[=circular_var]{circular_var()}}.
}
